@extends('layouts.app')

@section('title', 'Learning Path Progress')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">{{ $enrollment->learningPath->title }} - Progress</h1>
                <div class="btn-group">
                    <a href="{{ route('training.learning-paths.show', $enrollment->learningPath) }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Learning Path
                    </a>
                    <a href="{{ route('training.learning-paths.my-paths') }}" class="btn btn-outline-primary">
                        <i class="bi bi-person"></i> My Learning Paths
                    </a>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <!-- Progress Overview -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">Overall Progress</h5>
                                <span class="badge bg-{{ $enrollment->status === 'completed' ? 'success' : ($enrollment->status === 'in_progress' ? 'warning' : 'info') }}">
                                    {{ ucfirst(str_replace('_', ' ', $enrollment->status)) }}
                                </span>
                            </div>
                            
                            <div class="progress mb-3" style="height: 20px;">
                                <div class="progress-bar bg-{{ $enrollment->status === 'completed' ? 'success' : 'primary' }}" 
                                     style="width: {{ $enrollment->progress_percentage }}%">
                                    {{ number_format($enrollment->progress_percentage, 1) }}%
                                </div>
                            </div>

                            <div class="row text-center">
                                <div class="col-md-3">
                                    <h6 class="text-muted">Current Step</h6>
                                    <h4>{{ $enrollment->current_step }}/{{ $enrollment->learningPath->total_steps }}</h4>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-muted">Enrolled</h6>
                                    <p class="mb-0">{{ $enrollment->enrolled_at->format('M j, Y') }}</p>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-muted">Started</h6>
                                    <p class="mb-0">{{ $enrollment->started_at ? $enrollment->started_at->format('M j, Y') : 'Not started' }}</p>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-muted">Estimated Duration</h6>
                                    <p class="mb-0">{{ $enrollment->learningPath->estimated_duration_hours }} hours</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Learning Steps Progress -->
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="bi bi-list-check"></i> Learning Steps</h5>
                            <form method="POST" action="{{ route('training.learning-paths.update-progress', $enrollment) }}" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-outline-primary btn-sm">
                                    <i class="bi bi-arrow-clockwise"></i> Update Progress
                                </button>
                            </form>
                        </div>
                        <div class="card-body">
                            @if($enrollment->learningPath->steps->count() > 0)
                                @foreach($enrollment->learningPath->steps as $step)
                                    @php
                                        $isCompleted = $stepProgress[$step->id]['completed'] ?? false;
                                        $isCurrent = $step->step_order == $enrollment->current_step;
                                        $isPast = $step->step_order < $enrollment->current_step;
                                        $isFuture = $step->step_order > $enrollment->current_step;
                                    @endphp
                                    
                                    <div class="d-flex align-items-start mb-4 {{ !$loop->last ? 'border-bottom pb-4' : '' }}">
                                        <div class="flex-shrink-0 me-3">
                                            <div class="rounded-circle d-flex align-items-center justify-content-center" 
                                                 style="width: 50px; height: 50px;"
                                                 class="bg-{{ $isCompleted ? 'success' : ($isCurrent ? 'primary' : ($isPast ? 'warning' : 'light')) }} 
                                                        text-{{ $isCompleted || $isCurrent || $isPast ? 'white' : 'dark' }}">
                                                @if($isCompleted)
                                                    <i class="bi bi-check-lg"></i>
                                                @elseif($isCurrent)
                                                    <i class="bi bi-play-fill"></i>
                                                @else
                                                    {{ $step->step_order }}
                                                @endif
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h6 class="mb-1">
                                                        Step {{ $step->step_order }}: {{ $step->trainingProgram->title }}
                                                        @if($isCurrent)
                                                            <span class="badge bg-primary ms-2">Current</span>
                                                        @endif
                                                    </h6>
                                                    <div class="mb-2">
                                                        @if($step->is_required)
                                                            <span class="badge bg-danger">Required</span>
                                                        @else
                                                            <span class="badge bg-secondary">Optional</span>
                                                        @endif
                                                        @if($isCompleted)
                                                            <span class="badge bg-success">Completed</span>
                                                        @elseif($isCurrent)
                                                            <span class="badge bg-warning">In Progress</span>
                                                        @elseif($isFuture)
                                                            <span class="badge bg-light text-dark">Upcoming</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <p class="text-muted mb-2">{{ Str::limit($step->trainingProgram->description, 150) }}</p>
                                            
                                            <div class="row align-items-center">
                                                <div class="col-md-6">
                                                    <small class="text-muted">
                                                        <i class="bi bi-clock"></i> {{ $step->trainingProgram->duration_hours }} hours
                                                        <i class="bi bi-tag ms-2"></i> {{ $step->trainingProgram->category->name }}
                                                        <i class="bi bi-signal ms-2"></i> {{ ucfirst($step->trainingProgram->difficulty_level) }}
                                                    </small>
                                                </div>
                                                <div class="col-md-6 text-end">
                                                    <div class="btn-group btn-group-sm">
                                                        <a href="{{ route('training.programs.show', $step->trainingProgram) }}" 
                                                           class="btn btn-outline-primary">
                                                            <i class="bi bi-eye"></i> View Program
                                                        </a>
                                                        @if($isCurrent && !$isCompleted)
                                                            <a href="{{ route('training.index') }}" 
                                                               class="btn btn-primary">
                                                                <i class="bi bi-play"></i> Start Training
                                                            </a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>

                                            @if($step->hasPrerequisites())
                                                <div class="mt-2">
                                                    <small class="text-muted">
                                                        <i class="bi bi-info-circle"></i> 
                                                        Prerequisites: Complete steps {{ implode(', ', $step->prerequisites) }} first
                                                    </small>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="text-center py-4">
                                    <i class="bi bi-list-check fs-1 text-muted"></i>
                                    <h5 class="mt-3">No Steps Available</h5>
                                    <p class="text-muted">This learning path doesn't have any steps configured yet.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Quick Stats -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-graph-up"></i> Your Progress</h5>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6 mb-3">
                                    <h6 class="text-muted">Completed Steps</h6>
                                    <h3 class="text-success">{{ collect($stepProgress)->where('completed', true)->count() }}</h3>
                                </div>
                                <div class="col-6 mb-3">
                                    <h6 class="text-muted">Remaining Steps</h6>
                                    <h3 class="text-primary">{{ collect($stepProgress)->where('completed', false)->count() }}</h3>
                                </div>
                                <div class="col-12">
                                    <h6 class="text-muted">Overall Progress</h6>
                                    <h3 class="text-info">{{ number_format($enrollment->progress_percentage, 1) }}%</h3>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Learning Path Info -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-info-circle"></i> Learning Path Info</h5>
                        </div>
                        <div class="card-body">
                            <h6>{{ $enrollment->learningPath->title }}</h6>
                            <p class="text-muted small">{{ Str::limit($enrollment->learningPath->description, 100) }}</p>
                            
                            @if($enrollment->learningPath->learning_outcomes)
                                <div class="mb-3">
                                    <small class="text-muted">Learning Outcomes:</small>
                                    <ul class="small mb-0">
                                        @foreach(array_slice($enrollment->learningPath->learning_outcomes, 0, 3) as $outcome)
                                            <li>{{ $outcome }}</li>
                                        @endforeach
                                        @if(count($enrollment->learningPath->learning_outcomes) > 3)
                                            <li class="text-muted">+{{ count($enrollment->learningPath->learning_outcomes) - 3 }} more...</li>
                                        @endif
                                    </ul>
                                </div>
                            @endif

                            <div class="row text-center">
                                <div class="col-6">
                                    <small class="text-muted">Difficulty</small><br>
                                    <span class="badge bg-{{ $enrollment->learningPath->difficulty_color }}">
                                        {{ ucfirst($enrollment->learningPath->difficulty_level) }}
                                    </span>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Duration</small><br>
                                    <strong>{{ $enrollment->learningPath->estimated_duration_hours }}h</strong>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Next Steps -->
                    @if($enrollment->status !== 'completed')
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="bi bi-arrow-right-circle"></i> Next Steps</h5>
                            </div>
                            <div class="card-body">
                                @php
                                    $currentStepDetails = $enrollment->getCurrentStepDetails();
                                    $nextStepDetails = $enrollment->getNextStepDetails();
                                @endphp
                                
                                @if($currentStepDetails)
                                    <div class="mb-3">
                                        <h6 class="text-primary">Current Step:</h6>
                                        <p class="mb-1"><strong>{{ $currentStepDetails->trainingProgram->title }}</strong></p>
                                        <small class="text-muted">{{ $currentStepDetails->trainingProgram->duration_hours }} hours</small>
                                    </div>
                                    
                                    <a href="{{ route('training.programs.show', $currentStepDetails->trainingProgram) }}" 
                                       class="btn btn-primary w-100 mb-3">
                                        <i class="bi bi-play"></i> Continue Current Step
                                    </a>
                                @endif

                                @if($nextStepDetails)
                                    <div class="mb-3">
                                        <h6 class="text-muted">Next Step:</h6>
                                        <p class="mb-1">{{ $nextStepDetails->trainingProgram->title }}</p>
                                        <small class="text-muted">{{ $nextStepDetails->trainingProgram->duration_hours }} hours</small>
                                    </div>
                                @endif

                                <div class="alert alert-info">
                                    <small>
                                        <i class="bi bi-lightbulb"></i>
                                        Complete your current step to automatically advance to the next one.
                                    </small>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="card">
                            <div class="card-body text-center">
                                <i class="bi bi-trophy fs-1 text-warning"></i>
                                <h5 class="mt-3 text-success">Congratulations!</h5>
                                <p class="text-muted">You have successfully completed this learning path.</p>
                                <small class="text-muted">
                                    Completed on {{ $enrollment->completed_at->format('M j, Y') }}
                                </small>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection