@extends('layouts.app')

@section('title', 'My Learning Paths')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">My Learning Paths</h1>
                <a href="{{ route('training.learning-paths.index') }}" class="btn btn-outline-primary">
                    <i class="bi bi-search"></i> Browse Learning Paths
                </a>
            </div>

            @if($enrollments->count() > 0)
                <div class="row">
                    @foreach($enrollments as $enrollment)
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100">
                                @if($enrollment->learningPath->image_path)
                                    <img src="{{ asset('storage/' . $enrollment->learningPath->image_path) }}" 
                                         class="card-img-top" alt="{{ $enrollment->learningPath->title }}" 
                                         style="height: 200px; object-fit: cover;">
                                @else
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                        <i class="bi bi-map fs-1 text-muted"></i>
                                    </div>
                                @endif
                                
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h5 class="card-title">{{ $enrollment->learningPath->title }}</h5>
                                        <span class="badge bg-{{ $enrollment->learningPath->difficulty_color }}">
                                            {{ ucfirst($enrollment->learningPath->difficulty_level) }}
                                        </span>
                                    </div>
                                    
                                    <p class="card-text text-muted small flex-grow-1">
                                        {{ Str::limit($enrollment->learningPath->description, 100) }}
                                    </p>
                                    
                                    <!-- Progress Bar -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between align-items-center mb-1">
                                            <small class="text-muted">Progress</small>
                                            <small class="text-muted">{{ number_format($enrollment->progress_percentage, 1) }}%</small>
                                        </div>
                                        <div class="progress" style="height: 8px;">
                                            <div class="progress-bar bg-{{ $enrollment->status === 'completed' ? 'success' : 'primary' }}" 
                                                 style="width: {{ $enrollment->progress_percentage }}%"></div>
                                        </div>
                                    </div>

                                    <!-- Status and Stats -->
                                    <div class="mb-3">
                                        <div class="row text-center">
                                            <div class="col-4">
                                                <small class="text-muted">Status</small><br>
                                                <span class="badge bg-{{ $enrollment->status === 'completed' ? 'success' : ($enrollment->status === 'in_progress' ? 'warning' : 'info') }}">
                                                    {{ ucfirst(str_replace('_', ' ', $enrollment->status)) }}
                                                </span>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Current Step</small><br>
                                                <strong>{{ $enrollment->current_step }}/{{ $enrollment->learningPath->total_steps }}</strong>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Duration</small><br>
                                                <strong>{{ $enrollment->learningPath->estimated_duration_hours }}h</strong>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Enrollment Info -->
                                    <div class="mb-3">
                                        <small class="text-muted">
                                            Enrolled: {{ $enrollment->enrolled_at->format('M j, Y') }}
                                            @if($enrollment->started_at)
                                                <br>Started: {{ $enrollment->started_at->format('M j, Y') }}
                                            @endif
                                            @if($enrollment->completed_at)
                                                <br>Completed: {{ $enrollment->completed_at->format('M j, Y') }}
                                            @endif
                                        </small>
                                    </div>
                                    
                                    <div class="mt-auto">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <a href="{{ route('training.learning-paths.show', $enrollment->learningPath) }}" 
                                               class="btn btn-outline-primary btn-sm">
                                                <i class="bi bi-eye"></i> View Path
                                            </a>
                                            
                                            @if($enrollment->status !== 'completed')
                                                <a href="{{ route('training.learning-paths.progress', $enrollment) }}" 
                                                   class="btn btn-primary btn-sm">
                                                    <i class="bi bi-play"></i> Continue
                                                </a>
                                            @else
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Completed
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $enrollments->links() }}
                </div>
            @else
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-map fs-1 text-muted"></i>
                        <h4 class="mt-3">No Learning Paths Yet</h4>
                        <p class="text-muted">You haven't enrolled in any learning paths yet. Start your learning journey today!</p>
                        <a href="{{ route('training.learning-paths.index') }}" class="btn btn-primary">
                            <i class="bi bi-search"></i> Browse Learning Paths
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection