@extends('layouts.app')

@section('title', 'Create Learning Path')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header 
                title="Create Learning Path"
                backUrl="{{ route('training.learning-paths.index') }}"
                backText="Back to Learning Paths" />

            <div class="card">
                <div class="card-body">
                    <form method="POST" action="{{ route('training.learning-paths.store') }}" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-8">
                                <x-form.input name="title" label="Learning Path Title" required />
                            </div>
                            
                            <div class="col-md-4">
                                <x-form.select 
                                    name="difficulty_level" 
                                    label="Difficulty Level" 
                                    required
                                    :options="[
                                        'beginner' => 'Beginner',
                                        'intermediate' => 'Intermediate',
                                        'advanced' => 'Advanced'
                                    ]" />
                            </div>
                        </div>

                        <x-form.textarea 
                            name="description" 
                            label="Description" 
                            required
                            rows="4"
                            placeholder="Describe what this learning path covers and its objectives..." />

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input 
                                    type="number" 
                                    name="estimated_duration_hours" 
                                    label="Estimated Duration (Hours)" 
                                    required
                                    min="1" />
                            </div>
                            
                            <div class="col-md-6">
                                <x-form.file 
                                    name="image" 
                                    label="Learning Path Image"
                                    accept="image/*"
                                    help="Upload an image to represent this learning path (optional)" />
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="target_roles" class="form-label">Target Roles</label>
                            <select class="form-select" id="target_roles" name="target_roles[]" multiple>
                                @foreach($departments as $department)
                                    <optgroup label="{{ $department->name }}">
                                        @foreach($department->positions as $position)
                                            <option value="{{ $position->id }}" 
                                                {{ in_array($position->id, old('target_roles', [])) ? 'selected' : '' }}>
                                                {{ $position->title }}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                @endforeach
                            </select>
                            <div class="form-text">Select positions that would benefit from this learning path</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Learning Outcomes</label>
                            <div id="learning-outcomes">
                                @if(old('learning_outcomes'))
                                    @foreach(old('learning_outcomes') as $index => $outcome)
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="learning_outcomes[]" 
                                                   value="{{ $outcome }}" placeholder="What will learners achieve?">
                                            <button type="button" class="btn btn-outline-danger remove-outcome">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" name="learning_outcomes[]" 
                                               placeholder="What will learners achieve?">
                                        <button type="button" class="btn btn-outline-danger remove-outcome">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                @endif
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-outcome">
                                <i class="bi bi-plus"></i> Add Learning Outcome
                            </button>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">Learning Path Steps <span class="text-danger">*</span></label>
                            <div id="learning-steps">
                                @if(old('steps'))
                                    @foreach(old('steps') as $index => $step)
                                        <div class="card mb-3 step-card">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center mb-3">
                                                    <h6 class="mb-0">Step {{ $index + 1 }}</h6>
                                                    <button type="button" class="btn btn-outline-danger btn-sm remove-step">
                                                        <i class="bi bi-trash"></i> Remove
                                                    </button>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-8">
                                                        <select class="form-select" name="steps[{{ $index }}][training_program_id]" required>
                                                            <option value="">Select Training Program</option>
                                                            @foreach($trainingPrograms as $program)
                                                                <option value="{{ $program->id }}" 
                                                                    {{ $step['training_program_id'] == $program->id ? 'selected' : '' }}>
                                                                    {{ $program->title }} ({{ $program->category->name }})
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" 
                                                                   name="steps[{{ $index }}][is_required]" value="1"
                                                                   {{ ($step['is_required'] ?? true) ? 'checked' : '' }}>
                                                            <label class="form-check-label">Required Step</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="card mb-3 step-card">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                <h6 class="mb-0">Step 1</h6>
                                                <button type="button" class="btn btn-outline-danger btn-sm remove-step">
                                                    <i class="bi bi-trash"></i> Remove
                                                </button>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <select class="form-select" name="steps[0][training_program_id]" required>
                                                        <option value="">Select Training Program</option>
                                                        @foreach($trainingPrograms as $program)
                                                            <option value="{{ $program->id }}">
                                                                {{ $program->title }} ({{ $program->category->name }})
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" 
                                                               name="steps[0][is_required]" value="1" checked>
                                                        <label class="form-check-label">Required Step</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <button type="button" class="btn btn-outline-primary" id="add-step">
                                <i class="bi bi-plus"></i> Add Step
                            </button>
                        </div>

                        <x-form.button-group 
                            cancelUrl="{{ route('training.learning-paths.index') }}"
                            submitText="Create Learning Path"
                            submitIcon="bi-check" />
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    let stepIndex = {{ old('steps') ? count(old('steps')) : 1 }};
    
    // Add learning outcome
    document.getElementById('add-outcome').addEventListener('click', function() {
        const container = document.getElementById('learning-outcomes');
        const div = document.createElement('div');
        div.className = 'input-group mb-2';
        div.innerHTML = `
            <input type="text" class="form-control" name="learning_outcomes[]" 
                   placeholder="What will learners achieve?">
            <button type="button" class="btn btn-outline-danger remove-outcome">
                <i class="bi bi-trash"></i>
            </button>
        `;
        container.appendChild(div);
    });
    
    // Remove learning outcome
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-outcome')) {
            const outcomes = document.querySelectorAll('#learning-outcomes .input-group');
            if (outcomes.length > 1) {
                e.target.closest('.input-group').remove();
            }
        }
    });
    
    // Add learning step
    document.getElementById('add-step').addEventListener('click', function() {
        const container = document.getElementById('learning-steps');
        const div = document.createElement('div');
        div.className = 'card mb-3 step-card';
        div.innerHTML = `
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0">Step ${stepIndex + 1}</h6>
                    <button type="button" class="btn btn-outline-danger btn-sm remove-step">
                        <i class="bi bi-trash"></i> Remove
                    </button>
                </div>
                <div class="row">
                    <div class="col-md-8">
                        <select class="form-select" name="steps[${stepIndex}][training_program_id]" required>
                            <option value="">Select Training Program</option>
                            @foreach($trainingPrograms as $program)
                                <option value="{{ $program->id }}">
                                    {{ $program->title }} ({{ $program->category->name }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" 
                                   name="steps[${stepIndex}][is_required]" value="1" checked>
                            <label class="form-check-label">Required Step</label>
                        </div>
                    </div>
                </div>
            </div>
        `;
        container.appendChild(div);
        stepIndex++;
        updateStepNumbers();
    });
    
    // Remove learning step
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-step')) {
            const steps = document.querySelectorAll('.step-card');
            if (steps.length > 1) {
                e.target.closest('.step-card').remove();
                updateStepNumbers();
            }
        }
    });
    
    function updateStepNumbers() {
        const steps = document.querySelectorAll('.step-card');
        steps.forEach((step, index) => {
            step.querySelector('h6').textContent = `Step ${index + 1}`;
        });
    }
});
</script>
@endpush
@endsection
