@extends('layouts.app')

@section('title', 'Training Programs')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header title="Training Programs" description="Browse and manage training programs">
                <x-slot:actions>
                    @can('create', App\Models\TrainingProgram::class)
                    <a href="{{ route('training.programs.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Create Program
                    </a>
                    @endcan
                </x-slot:actions>
            </x-page-header>

            <x-alert type="success" :message="session('success')" />

            <!-- Filters -->
            <x-filter-form :action="route('training.index')">
                <div class="col-md-3">
                    <select name="category" class="form-select">
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select">
                        <option value="">All Types</option>
                        <option value="internal" {{ request('type') == 'internal' ? 'selected' : '' }}>Internal</option>
                        <option value="external" {{ request('type') == 'external' ? 'selected' : '' }}>External</option>
                        <option value="online" {{ request('type') == 'online' ? 'selected' : '' }}>Online</option>
                        <option value="workshop" {{ request('type') == 'workshop' ? 'selected' : '' }}>Workshop</option>
                        <option value="seminar" {{ request('type') == 'seminar' ? 'selected' : '' }}>Seminar</option>
                        <option value="certification" {{ request('type') == 'certification' ? 'selected' : '' }}>Certification</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="difficulty" class="form-select">
                        <option value="">All Levels</option>
                        <option value="beginner" {{ request('difficulty') == 'beginner' ? 'selected' : '' }}>Beginner</option>
                        <option value="intermediate" {{ request('difficulty') == 'intermediate' ? 'selected' : '' }}>Intermediate</option>
                        <option value="advanced" {{ request('difficulty') == 'advanced' ? 'selected' : '' }}>Advanced</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="Search programs..." value="{{ request('search') }}">
                </div>
            </x-filter-form>

            <!-- Training Programs Grid -->
            <div class="row">
                @forelse($programs as $program)
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card h-100">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span class="badge" style="background-color: {{ $program->category->color }}">
                                    {{ $program->category->name }}
                                </span>
                                <small class="text-muted">{{ ucfirst($program->type) }}</small>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">{{ $program->title }}</h5>
                                <p class="card-text">{{ Str::limit($program->description, 100) }}</p>
                                
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="bi bi-clock"></i> {{ $program->formatted_duration }}
                                        @if($program->cost_per_participant > 0)
                                            | <i class="bi bi-dollar-sign"></i> Ksh{{ number_format($program->cost_per_participant, 2) }}
                                        @endif
                                    </small>
                                </div>

                                <div class="mb-2">
                                    <span class="badge badge-{{ $program->difficulty_level == 'beginner' ? 'success' : ($program->difficulty_level == 'intermediate' ? 'warning' : 'danger') }}">
                                        {{ ucfirst($program->difficulty_level) }}
                                    </span>
                                    @if($program->is_mandatory)
                                        <span class="badge badge-info">Mandatory</span>
                                    @endif
                                </div>
                            </div>
                            <div class="card-footer">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('training.programs.show', $program) }}" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-eye"></i> View Details
                                    </a>
                                    @if(in_array($program->id, $userEnrollments))
                                        <span class="badge badge-success">Enrolled</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12">
                        <div class="text-center py-5">
                            <i class="bi bi-graduation-cap fa-3x text-muted mb-3"></i>
                            <h4>No Training Programs Found</h4>
                            <p class="text-muted">No training programs match your current filters.</p>
                        </div>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center">
                {{ $programs->withQueryString()->links() }}
            </div>
        </div>
    </div>
</div>
@endsection