@extends('systemadmin.layouts.app')

@section('title', 'Subscription Management')
@section('page-title', 'Subscription Management')

@section('content')
<x-page-header title="Subscription Management" description="Manage all organization subscriptions" />

<x-alert type="success" :message="session('success')" />

<!-- Statistics Cards -->
<x-stats-grid :stats="[
    ['value' => $stats['total'], 'label' => 'Total Subscriptions', 'icon' => 'receipt', 'type' => 'primary'],
    ['value' => $stats['active'], 'label' => 'Active', 'icon' => 'check-circle', 'type' => 'success'],
    ['value' => $stats['trial'], 'label' => 'On Trial', 'icon' => 'clock-history', 'type' => 'info'],
    ['value' => $stats['suspended'], 'label' => 'Suspended', 'icon' => 'pause-circle', 'type' => 'warning'],
]" />

<!-- Filters -->
<x-filter-form :action="route('systemadmin.subscriptions.index')">
    <div class="col-md-3">
        <input type="text" name="search" class="form-control" placeholder="Search organization..." value="{{ request('search') }}">
    </div>
    <div class="col-md-3">
        <select name="status" class="form-select">
            <option value="">All Statuses</option>
            <option value="trial" {{ request('status') == 'trial' ? 'selected' : '' }}>Trial</option>
            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
            <option value="suspended" {{ request('status') == 'suspended' ? 'selected' : '' }}>Suspended</option>
            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
        </select>
    </div>
    <div class="col-md-3">
        <select name="plan_id" class="form-select">
            <option value="">All Plans</option>
            @foreach($plans as $plan)
                <option value="{{ $plan->id }}" {{ request('plan_id') == $plan->id ? 'selected' : '' }}>
                    {{ $plan->name }}
                </option>
            @endforeach
        </select>
    </div>
    <div class="col-md-3">
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-search"></i> Filter
        </button>
        <a href="{{ route('systemadmin.subscriptions.index') }}" class="btn btn-secondary">
            <i class="bi bi-x"></i> Clear
        </a>
    </div>
</x-filter-form>

<!-- Subscriptions Table -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Subscriptions</h5>
    </div>
    <div class="card-body">
        @if($subscriptions->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Organization</th>
                            <th>Plan</th>
                            <th>Status</th>
                            <th>Billing Cycle</th>
                            <th>Next Billing</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($subscriptions as $subscription)
                        <tr>
                            <td>
                                <strong>{{ $subscription->organization->name }}</strong>
                                <br><small class="text-muted">{{ $subscription->organization->slug }}</small>
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $subscription->plan->name }}</span>
                            </td>
                            <td>
                                @php
                                    $statusColors = [
                                        'trial' => 'info',
                                        'active' => 'success',
                                        'suspended' => 'warning',
                                        'cancelled' => 'danger',
                                        'expired' => 'secondary'
                                    ];
                                    $color = $statusColors[$subscription->status] ?? 'secondary';
                                @endphp
                                <span class="badge bg-{{ $color }}">{{ ucfirst($subscription->status) }}</span>
                                @if($subscription->onTrial())
                                    <br><small class="text-muted">{{ $subscription->trialDaysRemaining() }} days left</small>
                                @endif
                            </td>
                            <td>{{ ucfirst($subscription->billing_cycle) }}</td>
                            <td>
                                @if($subscription->next_billing_date)
                                    {{ $subscription->next_billing_date->format('M d, Y') }}
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('systemadmin.subscriptions.show', $subscription) }}" 
                                       class="btn btn-sm btn-outline-primary" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('systemadmin.subscriptions.edit', $subscription) }}" 
                                       class="btn btn-sm btn-outline-secondary" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center mt-3">
                {{ $subscriptions->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-receipt display-4 text-muted"></i>
                <h4 class="mt-3">No Subscriptions Found</h4>
                <p class="text-muted">No subscriptions match your filters.</p>
            </div>
        @endif
    </div>
</div>
@endsection
