@extends('systemadmin.layouts.app')

@section('title', 'Edit Subscription')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2><i class="bi bi-pencil"></i> Edit Subscription</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('systemadmin.dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('systemadmin.subscriptions.index') }}">Subscriptions</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('systemadmin.subscriptions.show', $subscription) }}">{{ $subscription->organization->name }}</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-star"></i> Subscription Details</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('systemadmin.subscriptions.update', $subscription) }}">
                        @csrf
                        @method('PUT')

                        <!-- Organization Info (Read-only) -->
                        <div class="mb-4">
                            <h6>Organization</h6>
                            <p class="text-muted">{{ $subscription->organization->name }}</p>
                        </div>

                        <!-- Plan Selection -->
                        <div class="mb-3">
                            <label for="plan_id" class="form-label">Subscription Plan <span class="text-danger">*</span></label>
                            <select class="form-select @error('plan_id') is-invalid @enderror" 
                                    id="plan_id" 
                                    name="plan_id" 
                                    required>
                                <option value="">Select a plan</option>
                                @foreach($plans as $plan)
                                    <option value="{{ $plan->id }}" 
                                            {{ old('plan_id', $subscription->plan_id) == $plan->id ? 'selected' : '' }}>
                                        {{ $plan->name }} - KES {{ number_format($plan->price_monthly, 0) }}/month
                                    </option>
                                @endforeach
                            </select>
                            @error('plan_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Billing Cycle -->
                        <div class="mb-3">
                            <label for="billing_cycle" class="form-label">Billing Cycle <span class="text-danger">*</span></label>
                            <select class="form-select @error('billing_cycle') is-invalid @enderror" 
                                    id="billing_cycle" 
                                    name="billing_cycle" 
                                    required>
                                <option value="monthly" {{ old('billing_cycle', $subscription->billing_cycle) === 'monthly' ? 'selected' : '' }}>
                                    Monthly
                                </option>
                                <option value="annual" {{ old('billing_cycle', $subscription->billing_cycle) === 'annual' ? 'selected' : '' }}>
                                    Annual
                                </option>
                            </select>
                            @error('billing_cycle')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Status -->
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select @error('status') is-invalid @enderror" 
                                    id="status" 
                                    name="status" 
                                    required>
                                <option value="trial" {{ old('status', $subscription->status) === 'trial' ? 'selected' : '' }}>
                                    Trial
                                </option>
                                <option value="active" {{ old('status', $subscription->status) === 'active' ? 'selected' : '' }}>
                                    Active
                                </option>
                                <option value="suspended" {{ old('status', $subscription->status) === 'suspended' ? 'selected' : '' }}>
                                    Suspended
                                </option>
                                <option value="cancelled" {{ old('status', $subscription->status) === 'cancelled' ? 'selected' : '' }}>
                                    Cancelled
                                </option>
                                <option value="expired" {{ old('status', $subscription->status) === 'expired' ? 'selected' : '' }}>
                                    Expired
                                </option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Trial End Date -->
                        <div class="mb-3" id="trial-end-group" style="display: {{ old('status', $subscription->status) === 'trial' ? 'block' : 'none' }};">
                            <label for="trial_ends_at" class="form-label">Trial End Date</label>
                            <input type="date" 
                                   class="form-control @error('trial_ends_at') is-invalid @enderror" 
                                   id="trial_ends_at" 
                                   name="trial_ends_at" 
                                   value="{{ old('trial_ends_at', $subscription->trial_ends_at ? $subscription->trial_ends_at->format('Y-m-d') : '') }}">
                            @error('trial_ends_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Current Period End Date -->
                        <div class="mb-3">
                            <label for="current_period_ends_at" class="form-label">Current Period End Date</label>
                            <input type="date" 
                                   class="form-control @error('current_period_ends_at') is-invalid @enderror" 
                                   id="current_period_ends_at" 
                                   name="current_period_ends_at" 
                                   value="{{ old('current_period_ends_at', $subscription->current_period_ends_at ? $subscription->current_period_ends_at->format('Y-m-d') : '') }}">
                            @error('current_period_ends_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Started At -->
                        <div class="mb-3">
                            <label for="started_at" class="form-label">Started At</label>
                            <input type="datetime-local" 
                                   class="form-control @error('started_at') is-invalid @enderror" 
                                   id="started_at" 
                                   name="started_at" 
                                   value="{{ old('started_at', $subscription->started_at ? $subscription->started_at->format('Y-m-d\TH:i') : '') }}">
                            @error('started_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Ends At -->
                        <div class="mb-3">
                            <label for="ends_at" class="form-label">Ends At</label>
                            <input type="date" 
                                   class="form-control @error('ends_at') is-invalid @enderror" 
                                   id="ends_at" 
                                   name="ends_at" 
                                   value="{{ old('ends_at', $subscription->ends_at ? $subscription->ends_at->format('Y-m-d') : '') }}">
                            <small class="form-text text-muted">Leave empty for ongoing subscription</small>
                            @error('ends_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Update Subscription
                            </button>
                            <a href="{{ route('systemadmin.subscriptions.show', $subscription) }}" class="btn btn-outline-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Help Section -->
        <div class="col-md-4">
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> Help</h6>
                </div>
                <div class="card-body">
                    <h6>Status Meanings:</h6>
                    <ul class="small">
                        <li><strong>Trial:</strong> Organization is in trial period</li>
                        <li><strong>Active:</strong> Paid and active subscription</li>
                        <li><strong>Suspended:</strong> Temporarily suspended by admin</li>
                        <li><strong>Cancelled:</strong> Cancelled by user or admin</li>
                        <li><strong>Expired:</strong> Subscription has expired</li>
                    </ul>

                    <h6 class="mt-3">Important Notes:</h6>
                    <ul class="small">
                        <li>Changing the plan will affect resource limits immediately</li>
                        <li>Trial end date is only used when status is "Trial"</li>
                        <li>Current period end date determines next billing date</li>
                        <li>Be careful when changing status manually</li>
                    </ul>
                </div>
            </div>

            <div class="card mt-3 border-warning">
                <div class="card-header bg-warning text-dark">
                    <h6 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Warning</h6>
                </div>
                <div class="card-body">
                    <p class="small mb-0">
                        Manual changes to subscriptions should be done carefully. 
                        Consider using the action buttons on the subscription details page instead.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('status').addEventListener('change', function() {
    const trialEndGroup = document.getElementById('trial-end-group');
    if (this.value === 'trial') {
        trialEndGroup.style.display = 'block';
    } else {
        trialEndGroup.style.display = 'none';
    }
});
</script>
@endpush
@endsection
