@extends('systemadmin.layouts.app')

@section('title', 'Organizations')
@section('page-title', 'Organizations Management')

@section('content')
<x-page-header title="Organizations" description="Manage all organizations">
    <x-slot:actions>
        <a href="{{ route('systemadmin.organizations.create') }}" class="btn btn-primary">
            <i class="bi bi-plus"></i> Create Organization
        </a>
    </x-slot:actions>
</x-page-header>

<x-alert type="success" :message="session('success')" />

<div class="card">
    <div class="card-body">
        @if($organizations->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Organization</th>
                            <th>Status</th>
                            <th>Users</th>
                            <th>Employees</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($organizations as $organization)
                        <tr>
                            <td>
                                <div>
                                    <strong>{{ $organization->name }}</strong>
                                    <br><small class="text-muted">Slug: {{ $organization->slug }}</small>
                                </div>
                            </td>
                            <td>
                                <x-status-badge :status="$organization->status" />
                            </td>
                            <td>
                                <span class="badge bg-info">{{ $organization->users_count }}</span>
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $organization->employees_count }}</span>
                            </td>
                            <td>{{ $organization->created_at->format('M d, Y') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('systemadmin.organizations.show', $organization) }}" 
                                       class="btn btn-sm btn-outline-primary" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('systemadmin.organizations.edit', $organization) }}" 
                                       class="btn btn-sm btn-outline-secondary" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="confirmDelete('{{ $organization->id }}')" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center">
                {{ $organizations->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-building display-4 text-muted"></i>
                <h4 class="mt-3">No Organizations Found</h4>
                <p class="text-muted">Create your first organization to get started.</p>
                <a href="{{ route('systemadmin.organizations.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus"></i> Create Organization
                </a>
            </div>
        @endif
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this organization? This action cannot be undone.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function confirmDelete(organizationId) {
    const form = document.getElementById('deleteForm');
    form.action = `/systemadmin/organizations/${organizationId}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
@endpush