<!-- Mobile Overlay -->
<div class="sidebar-overlay d-lg-none" id="sidebarOverlay"></div>

<!-- System Admin Sidebar -->
<div class="sidebar system-admin" id="sidebar">
    <!-- Mobile Close Button -->
    <button class="sidebar-close-btn d-lg-none" id="closeSidebar">
        <i class="bi bi-x-lg"></i>
    </button>
    
    <div class="logo">
        <i class="bi bi-shield-check"></i> Qaya HRM
    </div>
    
    <div class="system-admin-badge">
        <i class="bi bi-gear-fill"></i> SYSTEM ADMIN
    </div>
    
    <nav class="nav flex-column">
        <a href="{{ route('systemadmin.dashboard') }}" class="nav-link {{ request()->routeIs('systemadmin.dashboard') ? 'active' : '' }}">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>

        <a href="{{ route('systemadmin.organizations.index') }}" class="nav-link {{ request()->routeIs('systemadmin.organizations.*') ? 'active' : '' }}">
            <i class="bi bi-building"></i> Organizations
        </a>

        <a href="{{ route('systemadmin.subscriptions.index') }}" class="nav-link {{ request()->routeIs('systemadmin.subscriptions.*') ? 'active' : '' }}">
            <i class="bi bi-star"></i> Subscriptions
        </a>

        <a href="{{ route('system-admin.audit-logs.index') }}" class="nav-link {{ request()->routeIs('system-admin.audit-logs.*') ? 'active' : '' }}">
            <i class="bi bi-clipboard-data"></i> System Audit Logs
        </a>

        <!-- Future system admin features can be added here -->
        <a href="#" class="nav-link disabled">
            <i class="bi bi-people"></i> System Users
        </a>

        <a href="#" class="nav-link disabled">
            <i class="bi bi-graph-up"></i> System Analytics
        </a>

        <a href="#" class="nav-link disabled">
            <i class="bi bi-gear"></i> System Settings
        </a>
    </nav>

    <!-- User Profile Section -->
    <div class="mt-auto p-3">
        <div class="dropdown">
            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="bi bi-person-circle me-2"></i>
                <div class="d-flex flex-column">
                    <span class="fw-bold">{{ auth()->user()->name }}</span>
                    <small class="text-muted">System Administrator</small>
                </div>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
                <li>
                    <a class="dropdown-item" href="#">
                        <i class="bi bi-person"></i> Profile
                    </a>
                </li>
                <li>
                    <a class="dropdown-item" href="#">
                        <i class="bi bi-gear"></i> Settings
                    </a>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li>
                    <form method="POST" action="{{ route('systemadmin.logout') }}">
                        @csrf
                        <button type="submit" class="dropdown-item">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </button>
                    </form>
                </li>
            </ul>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        const menuToggle = document.getElementById('menuToggle');
        const closeSidebar = document.getElementById('closeSidebar');

        // Toggle sidebar on mobile
        if (menuToggle) {
            menuToggle.addEventListener('click', function() {
                sidebar.classList.add('show');
                sidebarOverlay.classList.add('show');
                document.body.style.overflow = 'hidden';
            });
        }

        // Close sidebar
        function closeSidebarFunc() {
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            document.body.style.overflow = '';
        }

        if (closeSidebar) {
            closeSidebar.addEventListener('click', closeSidebarFunc);
        }

        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', closeSidebarFunc);
        }

        // Close sidebar when clicking on nav links on mobile
        const navLinks = sidebar.querySelectorAll('.nav-link:not(.dropdown-toggle)');
        navLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth < 992) {
                    closeSidebarFunc();
                }
            });
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 992) {
                closeSidebarFunc();
            }
        });
    });
</script>