@extends('systemadmin.layouts.app')

@section('title', 'System Audit Dashboard')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2>System Audit Dashboard</h2>
                <div>
                    <select class="form-select d-inline-block w-auto" id="daysFilter">
                        <option value="7" {{ $days == 7 ? 'selected' : '' }}>Last 7 days</option>
                        <option value="30" {{ $days == 30 ? 'selected' : '' }}>Last 30 days</option>
                        <option value="90" {{ $days == 90 ? 'selected' : '' }}>Last 90 days</option>
                    </select>
                    <a href="{{ route('system-admin.audit-logs.index') }}" class="btn btn-primary ms-2">
                        <i class="bi bi-list"></i> View All Logs
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Overall Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ number_format($overallStats['total_activities']) }}</h4>
                            <p class="mb-0">Total Activities</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-list fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $topOrganizations->count() }}</h4>
                            <p class="mb-0">Active Organizations</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $securityAlerts->count() }}</h4>
                            <p class="mb-0">Security Alerts</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-shield-alt fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $overallStats['by_category']['compliance'] ?? 0 }}</h4>
                            <p class="mb-0">Compliance Events</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-clipboard-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Security Alerts -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Recent Security Alerts</h5>
                </div>
                <div class="card-body">
                    @forelse($securityAlerts as $alert)
                        <div class="d-flex justify-content-between align-items-center mb-3 p-2 border-start border-danger border-3">
                            <div>
                                <strong>{{ $alert->description }}</strong><br>
                                <small class="text-muted">
                                    {{ $alert->organization ? $alert->organization->name : 'System' }} • 
                                    {{ $alert->created_at->diffForHumans() }}
                                </small>
                            </div>
                            <span class="badge bg-{{ $alert->severity_color }}">{{ ucfirst($alert->severity) }}</span>
                        </div>
                    @empty
                        <p class="text-muted text-center">No security alerts in the selected period.</p>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Top Organizations by Activity -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Most Active Organizations</h5>
                </div>
                <div class="card-body">
                    @forelse($topOrganizations as $org)
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <strong>{{ $org->organization->name }}</strong><br>
                                <small class="text-muted">{{ $org->organization->users->count() }} users</small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">{{ number_format($org->activity_count) }} activities</span>
                            </div>
                        </div>
                    @empty
                        <p class="text-muted text-center">No organization activity data available.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Organization Statistics -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Organization Activity Overview</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Organization</th>
                                    <th>Users</th>
                                    <th>Total Activities</th>
                                    <th>Security Events</th>
                                    <th>Compliance Events</th>
                                    <th>Avg. Activities/User</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orgStats as $stat)
                                    <tr>
                                        <td>
                                            <strong>{{ $stat['organization']->name }}</strong>
                                        </td>
                                        <td>{{ $stat['organization']->users->count() }}</td>
                                        <td>{{ number_format($stat['stats']['total_activities']) }}</td>
                                        <td>
                                            <span class="badge bg-danger">
                                                {{ $stat['stats']['by_category']['security'] ?? 0 }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                {{ $stat['stats']['by_category']['compliance'] ?? 0 }}
                                            </span>
                                        </td>
                                        <td>
                                            {{ $stat['organization']->users->count() > 0 
                                                ? number_format($stat['stats']['total_activities'] / $stat['organization']->users->count(), 1) 
                                                : '0' }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center text-muted">No organization data available.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#daysFilter').on('change', function() {
        const days = $(this).val();
        window.location.href = '{{ route("system-admin.audit-logs.dashboard") }}?days=' + days;
    });
});
</script>
@endpush