<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Choose a Base Theme</h5>
        <p class="text-muted mb-0 small">Select a preset theme as your starting point</p>
    </div>
    <div class="card-body">
        <input type="hidden" name="base_theme" value="{{ $currentTheme }}">
        
        <div class="row">
            @foreach($presetThemes as $themeKey => $theme)
            @if($themeKey !== 'system_admin') {{-- Hide system admin theme from selection --}}
            <div class="col-md-4 col-lg-3 mb-3">
                <div class="theme-card {{ $currentTheme === $themeKey ? 'active' : '' }}" 
                     data-theme="{{ $themeKey }}">
                    <div class="theme-preview" style="background: {{ $theme['colors']['primary'] }}">
                        <div class="theme-preview-sidebar" 
                             style="background: {{ is_array($theme['sidebar']) ? $theme['sidebar']['background'] : $theme['sidebar'] }}">
                        </div>
                        <div class="theme-preview-content">
                            <div class="theme-preview-header"></div>
                            <div class="theme-preview-cards"></div>
                        </div>
                    </div>
                    <div class="theme-card-body">
                        <h6>{{ $theme['name'] }}</h6>
                        <button type="button" class="btn btn-sm {{ $currentTheme === $themeKey ? 'btn-primary' : 'btn-outline-primary' }}">
                            @if($currentTheme === $themeKey)
                                <i class="bi bi-check-circle"></i> Selected
                            @else
                                Select Theme
                            @endif
                        </button>
                    </div>
                </div>
            </div>
            @endif
            @endforeach
        </div>
    </div>
</div>
