@extends('layouts.app')

@section('title', 'Organization Settings')
@section('page-title', 'Organization Settings')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Organization Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('settings.organization.update') }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Organization Name *</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                       id="name" name="name" value="{{ old('name', $organization->name) }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="logo" class="form-label">Organization Logo</label>
                                <input type="file" class="form-control @error('logo') is-invalid @enderror" 
                                       id="logo" name="logo" accept="image/*">
                                @error('logo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                @if($organization->logo)
                                    <div class="mt-2">
                                        <img src="{{ Storage::url($organization->logo) }}" 
                                             alt="Current Logo" class="img-thumbnail" style="max-height: 100px;">
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <hr class="my-4">
                    <h6 class="mb-3">Company Details</h6>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="company_email" class="form-label">Company Email</label>
                                <input type="email" class="form-control @error('settings.company_email') is-invalid @enderror" 
                                       id="company_email" name="settings[company_email]" 
                                       value="{{ old('settings.company_email', $organization->getSetting('company_email')) }}">
                                @error('settings.company_email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="company_phone" class="form-label">Company Phone</label>
                                <input type="text" class="form-control @error('settings.company_phone') is-invalid @enderror" 
                                       id="company_phone" name="settings[company_phone]" 
                                       value="{{ old('settings.company_phone', $organization->getSetting('company_phone')) }}">
                                @error('settings.company_phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="company_address" class="form-label">Company Address</label>
                        <textarea class="form-control @error('settings.company_address') is-invalid @enderror" 
                                  id="company_address" name="settings[company_address]" rows="3">{{ old('settings.company_address', $organization->getSetting('company_address')) }}</textarea>
                        @error('settings.company_address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="company_website" class="form-label">Company Website</label>
                        <input type="url" class="form-control @error('settings.company_website') is-invalid @enderror" 
                               id="company_website" name="settings[company_website]" 
                               value="{{ old('settings.company_website', $organization->getSetting('company_website')) }}"
                               placeholder="https://example.com">
                        @error('settings.company_website')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <hr class="my-4">
                    <h6 class="mb-3">Working Hours</h6>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="working_hours_start" class="form-label">Start Time</label>
                                <input type="time" class="form-control @error('settings.working_hours_start') is-invalid @enderror" 
                                       id="working_hours_start" name="settings[working_hours_start]" 
                                       value="{{ old('settings.working_hours_start', $organization->getSetting('working_hours_start', '09:00')) }}">
                                @error('settings.working_hours_start')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="working_hours_end" class="form-label">End Time</label>
                                <input type="time" class="form-control @error('settings.working_hours_end') is-invalid @enderror" 
                                       id="working_hours_end" name="settings[working_hours_end]" 
                                       value="{{ old('settings.working_hours_end', $organization->getSetting('working_hours_end', '17:00')) }}">
                                @error('settings.working_hours_end')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="timezone" class="form-label">Timezone</label>
                                <select class="form-select @error('settings.timezone') is-invalid @enderror" 
                                        id="timezone" name="settings[timezone]">
                                    <option value="UTC" {{ old('settings.timezone', $organization->getSetting('timezone', 'UTC')) === 'UTC' ? 'selected' : '' }}>UTC</option>
                                    <option value="Africa/Nairobi" {{ old('settings.timezone', $organization->getSetting('timezone')) === 'Africa/Nairobi' ? 'selected' : '' }}>Africa/Nairobi</option>
                                    <option value="America/New_York" {{ old('settings.timezone', $organization->getSetting('timezone')) === 'America/New_York' ? 'selected' : '' }}>America/New_York</option>
                                    <option value="Europe/London" {{ old('settings.timezone', $organization->getSetting('timezone')) === 'Europe/London' ? 'selected' : '' }}>Europe/London</option>
                                    <option value="Asia/Dubai" {{ old('settings.timezone', $organization->getSetting('timezone')) === 'Asia/Dubai' ? 'selected' : '' }}>Asia/Dubai</option>
                                </select>
                                @error('settings.timezone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('settings.index') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Back to Settings
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check"></i> Update Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Organization Info</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td><strong>Slug:</strong></td>
                        <td><code>{{ $organization->slug }}</code></td>
                    </tr>
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            <span class="badge bg-{{ $organization->status === 'active' ? 'success' : ($organization->status === 'inactive' ? 'secondary' : 'danger') }}">
                                {{ ucfirst($organization->status) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Created:</strong></td>
                        <td>{{ $organization->created_at->format('M d, Y') }}</td>
                    </tr>
                    <tr>
                        <td><strong>Users:</strong></td>
                        <td>{{ $organization->users()->count() }}</td>
                    </tr>
                    <tr>
                        <td><strong>Employees:</strong></td>
                        <td>{{ $organization->employees()->count() }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection