@extends('layouts.app')

@section('title', 'Roles & Permissions')
@section('page-title', 'Roles & Permissions Management')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Settings', 'url' => route('settings.index')],
        ['label' => 'Roles & Permissions']
    ]" />

    <x-page-header 
        title="System Roles" 
        description="Manage roles and their permissions">
        <x-slot:actions>
            <a href="{{ route('roles.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Create New Role
            </a>
        </x-slot:actions>
    </x-page-header>

    <x-alert type="success" :message="session('success')" />

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Role Name</th>
                                <th>Display Name</th>
                                <th>Permissions</th>
                                <th>Users</th>
                                <th>Can Manage Roles</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($roles as $role)
                                <tr>
                                    <td>
                                        <strong>{{ $role->name }}</strong>
                                        @if($role->name === 'system_admin')
                                            <span class="badge bg-danger ms-2">System</span>
                                        @elseif($role->name === 'org_admin')
                                            <span class="badge bg-warning ms-2">Admin</span>
                                        @endif
                                    </td>
                                    <td>{{ ucfirst(str_replace('_', ' ', $role->name)) }}</td>
                                    <td>
                                        <small class="text-muted">{{ $role->permissions->count() }} permissions</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $role->users_count }} users</span>
                                    </td>
                                    <td>
                                        @if(in_array($role->name, ['org_admin', 'system_admin']))
                                            <span class="badge bg-success">Yes</span>
                                        @else
                                            <span class="badge bg-secondary">No</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-success">Active</span>
                                    </td>
                                    <td>
                                        @if(!in_array($role->name, ['org_admin', 'system_admin']))
                                            <a href="{{ route('roles.edit', $role) }}" class="btn btn-sm btn-primary" title="Edit">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="{{ route('roles.destroy', $role) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" title="Delete"
                                                        onclick="return confirm('Are you sure you want to delete this role?')">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        @else
                                            <span class="badge bg-secondary">Protected</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">No roles found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
