@extends('layouts.app')

@section('title', 'Create Role')
@section('page-title', 'Create New Role')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Settings', 'url' => route('settings.index')],
        ['label' => 'Roles', 'url' => route('roles.index')],
        ['label' => 'Create']
    ]" />

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">
                <form action="{{ route('roles.store') }}" method="POST">
                    @csrf

                    <x-form.input 
                        name="name" 
                        label="Role Name" 
                        required
                        placeholder="e.g., manager, supervisor"
                        help="Use lowercase with underscores (e.g., hr_manager)" />

                    <hr class="my-4">

                    <h6 class="mb-3">Assign Permissions</h6>

                    @foreach($permissions as $group => $groupPermissions)
                        <div class="mb-4">
                            <h6 class="text-primary mb-3">
                                <i class="bi bi-folder"></i> {{ ucwords(str_replace('_', ' ', $group)) }}
                            </h6>
                            <div class="row">
                                @foreach($groupPermissions as $permission)
                                    <div class="col-md-3 mb-2">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input"
                                                   id="permission_{{ $permission->id }}"
                                                   name="permissions[]"
                                                   value="{{ $permission->id }}"
                                                   {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                {{ ucfirst(str_replace('_', ' ', $permission->name)) }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach

                    <x-form.actions submit-text="Create Role" :cancel-url="route('roles.index')" />
                </form>
            </div>
        </div>
    </div>
@endsection
