@extends('layouts.app')

@section('title', 'Recruitment Reports')
@section('page-title', 'Recruitment Analytics')

@section('content')
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('job-postings.index') }}">Recruitment</a></li>
                <li class="breadcrumb-item active">Reports</li>
            </ol>
        </nav>
    </div>

    <!-- Date Range Filter -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-md-3">
                    <label class="form-label">Date Range</label>
                    <select name="date_range" class="form-select" onchange="this.form.submit()">
                        <option value="7" {{ $dateRange == '7' ? 'selected' : '' }}>Last 7 days</option>
                        <option value="30" {{ $dateRange == '30' ? 'selected' : '' }}>Last 30 days</option>
                        <option value="90" {{ $dateRange == '90' ? 'selected' : '' }}>Last 90 days</option>
                        <option value="365" {{ $dateRange == '365' ? 'selected' : '' }}>Last year</option>
                    </select>
                </div>
                <div class="col-md-9 text-end">
                    <a href="{{ route('recruitment.reports.detailed') }}" class="btn btn-outline-primary">
                        <i class="bi bi-table"></i> Detailed Report
                    </a>
                    <a href="{{ route('recruitment.reports.export') }}?format=csv&date_range={{ $dateRange }}" class="btn btn-success">
                        <i class="bi bi-download"></i> Export CSV
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-primary">{{ $metrics['total_job_postings'] }}</h3>
                            <small class="text-muted">Total Job Postings</small>
                        </div>
                        <div class="text-primary">
                            <i class="bi bi-briefcase fs-2"></i>
                        </div>
                    </div>
                    <small class="text-success">{{ $metrics['active_job_postings'] }} active</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-success">{{ $metrics['total_applications'] }}</h3>
                            <small class="text-muted">Total Applications</small>
                        </div>
                        <div class="text-success">
                            <i class="bi bi-people fs-2"></i>
                        </div>
                    </div>
                    <small class="text-info">{{ $metrics['applications_this_period'] }} this period</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-warning">{{ $metrics['avg_time_to_hire'] }}</h3>
                            <small class="text-muted">Avg. Time to Hire (days)</small>
                        </div>
                        <div class="text-warning">
                            <i class="bi bi-clock fs-2"></i>
                        </div>
                    </div>
                    <small class="text-muted">Industry avg: 23 days</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-info">{{ $metrics['conversion_rate'] }}%</h3>
                            <small class="text-muted">Conversion Rate</small>
                        </div>
                        <div class="text-info">
                            <i class="bi bi-graph-up fs-2"></i>
                        </div>
                    </div>
                    <small class="text-muted">{{ $metrics['offers_extended'] }} offers extended</small>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Application Status Distribution -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Application Status Distribution</h5>
                </div>
                <div class="card-body">
                    <canvas id="statusChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Applications Over Time -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Applications Over Time</h5>
                </div>
                <div class="card-body">
                    <canvas id="timeChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Top Performing Job Postings -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Top Performing Job Postings</h5>
                </div>
                <div class="card-body">
                    @if($topJobPostings->count() > 0)
                        @foreach($topJobPostings as $job)
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div>
                                    <h6 class="mb-1">{{ $job->title }}</h6>
                                    <small class="text-muted">{{ $job->department->name ?? 'N/A' }}</small>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary">{{ $job->applications_count }} applications</span>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <p class="text-muted text-center">No job postings found</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Department Performance -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Department Performance</h5>
                </div>
                <div class="card-body">
                    @if($departmentStats->count() > 0)
                        @foreach($departmentStats as $dept)
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-1">
                                    <h6 class="mb-0">{{ $dept->department_name }}</h6>
                                    <small class="text-muted">{{ $dept->applications_count }} applications</small>
                                </div>
                                <div class="progress" style="height: 6px;">
                                    <div class="progress-bar" role="progressbar" 
                                         style="width: {{ min($dept->offer_rate, 100) }}%" 
                                         aria-valuenow="{{ $dept->offer_rate }}" 
                                         aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                                <small class="text-muted">{{ number_format($dept->offer_rate, 1) }}% offer rate</small>
                            </div>
                        @endforeach
                    @else
                        <p class="text-muted text-center">No department data available</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Applications -->
    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <h5 class="mb-0">Recent Applications</h5>
        </div>
        <div class="card-body">
            @if($recentApplications->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Applicant</th>
                                <th>Position</th>
                                <th>Department</th>
                                <th>Status</th>
                                <th>Applied</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentApplications as $application)
                                <tr>
                                    <td>
                                        <strong>{{ $application->full_name }}</strong><br>
                                        <small class="text-muted">{{ $application->email }}</small>
                                    </td>
                                    <td>{{ $application->jobPosting->title }}</td>
                                    <td>{{ $application->jobPosting->department->name ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $application->status === 'new' ? 'primary' : ($application->status === 'offered' ? 'success' : 'secondary') }}">
                                            {{ ucfirst($application->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $application->applied_at->diffForHumans() }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted text-center">No recent applications</p>
            @endif
        </div>
    </div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Status Distribution Chart
    const statusCtx = document.getElementById('statusChart').getContext('2d');
    const statusData = @json($statusDistribution);
    
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: Object.keys(statusData).map(status => status.charAt(0).toUpperCase() + status.slice(1)),
            datasets: [{
                data: Object.values(statusData),
                backgroundColor: [
                    '#0d6efd', '#6c757d', '#28a745', '#ffc107', '#dc3545', '#6f42c1'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Applications Over Time Chart
    const timeCtx = document.getElementById('timeChart').getContext('2d');
    const timeData = @json($applicationsOverTime);
    
    new Chart(timeCtx, {
        type: 'line',
        data: {
            labels: timeData.map(item => item.date),
            datasets: [{
                label: 'Applications',
                data: timeData.map(item => item.count),
                borderColor: '#0d6efd',
                backgroundColor: 'rgba(13, 110, 253, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
@endpush