<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Limit Reached - {{ $jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <div class="text-warning mb-4">
                            <i class="bi bi-exclamation-triangle-fill" style="font-size: 4rem;"></i>
                        </div>
                        
                        <h2 class="text-warning mb-3">Update Limit Reached</h2>
                        
                        <p class="text-muted mb-4">
                            You have already updated your application for the <strong>{{ $jobPosting->title }}</strong> position. 
                            For security and fairness reasons, each application can only be updated once.
                        </p>

                        <div class="bg-light p-3 rounded mb-4">
                            <h6 class="mb-2">Your Application Details:</h6>
                            <div class="row text-start">
                                <div class="col-sm-6">
                                    <small class="text-muted">Applicant:</small><br>
                                    <strong>{{ $existingApplication->full_name }}</strong>
                                </div>
                                <div class="col-sm-6">
                                    <small class="text-muted">Email:</small><br>
                                    <strong>{{ $existingApplication->email }}</strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Applied On:</small><br>
                                    <strong>{{ $existingApplication->applied_at->format('M d, Y H:i') }}</strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Last Updated:</small><br>
                                    <strong>{{ $existingApplication->last_updated_at ? $existingApplication->last_updated_at->format('M d, Y H:i') : 'Never' }}</strong>
                                </div>
                                <div class="col-12 mt-2">
                                    <small class="text-muted">Status:</small><br>
                                    <span class="badge bg-primary">{{ ucfirst($existingApplication->status) }}</span>
                                    <small class="text-muted ms-2">(Updates: {{ $existingApplication->updated_count }}/1)</small>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-warning">
                            <i class="bi bi-shield-exclamation"></i>
                            <strong>Important:</strong> Your application is currently being reviewed by our HR team. 
                            If you need to make significant changes, please contact us directly.
                        </div>

                        <div class="alert alert-info">
                            <i class="bi bi-telephone"></i>
                            <strong>Need to make changes?</strong><br>
                            Contact our HR department directly at:
                            <br><strong>Email:</strong> hr@{{ strtolower($jobPosting->organization->name) }}.com
                            <br><strong>Phone:</strong> Contact through our website
                        </div>

                        <div class="mt-4">
                            <p class="text-muted mb-3">
                                <strong>What happens next?</strong><br>
                                Our HR team will review your application and contact you if you're selected for the next stage.
                            </p>
                            
                            @php
                                $websiteUrl = $jobPosting->organization->website ?? config('app.url');
                            @endphp
                            
                            <a href="{{ $websiteUrl }}" class="btn btn-primary me-2">
                                <i class="bi bi-globe"></i> Visit Our Website
                            </a>
                            
                            <button onclick="window.print()" class="btn btn-outline-secondary">
                                <i class="bi bi-printer"></i> Print Details
                            </button>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <p class="text-muted small">
                        <i class="bi bi-shield-check"></i>
                        This policy ensures fairness for all applicants and maintains the integrity of our recruitment process.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>