<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Application - {{ $jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <!-- Header -->
                <div class="text-center mb-4">
                    <h2 class="text-primary">{{ $jobPosting->organization->name }}</h2>
                    <p class="text-muted">Update Your Application</p>
                </div>

                <!-- Existing Application Notice -->
                <div class="alert alert-info mb-4">
                    <i class="bi bi-info-circle"></i>
                    <strong>Application Found!</strong><br>
                    You've already applied for this position on {{ $existingApplication->applied_at->format('M d, Y') }}. 
                    Since your application is still being reviewed, you can update your information below.
                </div>

                <!-- Update Warning -->
                <div class="alert alert-warning mb-4">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>Important:</strong> You can only update your application <strong>once</strong>. 
                    After this update, no further changes will be allowed. Please review all information carefully before submitting.
                    <br><small class="mt-1 d-block">Updates used: {{ $existingApplication->updated_count }}/1</small>
                </div>

                <!-- Job Information Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <h3 class="card-title text-primary">{{ $jobPosting->title }}</h3>
                        <div class="row text-muted small mb-3">
                            @if($jobPosting->department)
                            <div class="col-md-6">
                                <i class="bi bi-building"></i> {{ $jobPosting->department->name }}
                            </div>
                            @endif
                            <div class="col-md-6">
                                <i class="bi bi-geo-alt"></i> {{ $jobPosting->location }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Update Application Form -->
                <div class="card shadow-sm">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0"><i class="bi bi-pencil-square"></i> Update Your Application</h5>
                    </div>
                    <div class="card-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <form method="POST" action="{{ route('public.apply.update', $jobPosting->public_token) }}" enctype="multipart/form-data" id="updateForm">
                            @csrf
                            @method('PUT')
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="first_name" class="form-label">First Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="first_name" name="first_name" value="{{ old('first_name', $existingApplication->first_name) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="last_name" class="form-label">Last Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="last_name" name="last_name" value="{{ old('last_name', $existingApplication->last_name) }}" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email Address</label>
                                    <input type="email" class="form-control" id="email" name="email" value="{{ $existingApplication->email }}" readonly>
                                    <div class="form-text">Email cannot be changed</div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" id="phone" name="phone" value="{{ old('phone', $existingApplication->phone) }}" placeholder="07XX XXX XXX" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="cv" class="form-label">Update CV/Resume (Optional)</label>
                                <input type="file" class="form-control" id="cv" name="cv" accept=".pdf,.doc,.docx">
                                <div class="form-text">
                                    Current CV: <strong>{{ basename($existingApplication->cv_path) }}</strong><br>
                                    Leave empty to keep current CV. Accepted formats: PDF, DOC, DOCX. Maximum size: 5MB
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="cover_letter" class="form-label">Cover Letter (Optional)</label>
                                <textarea class="form-control" id="cover_letter" name="cover_letter" rows="4" placeholder="Tell us why you're interested in this position...">{{ old('cover_letter', $existingApplication->cover_letter) }}</textarea>
                                <div class="form-text">Maximum 2000 characters</div>
                            </div>

                            <!-- Honeypot for spam protection -->
                            <input type="text" name="website" style="display: none;">

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-warning btn-lg" id="submitBtn">
                                    <i class="bi bi-arrow-repeat"></i> Update Application
                                </button>
                                <a href="{{ route('public.apply.show', $jobPosting->public_token) }}" class="btn btn-outline-secondary">
                                    <i class="bi bi-arrow-left"></i> Back to Application
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Footer -->
                <div class="text-center mt-4">
                    <p class="text-muted small">
                        Your application will be updated and the HR team will be notified of the changes.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Form validation and UX improvements
        document.getElementById('updateForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Updating...';
            submitBtn.disabled = true;
        });

        // File size validation
        document.getElementById('cv').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file && file.size > 5 * 1024 * 1024) { // 5MB
                alert('File size must be less than 5MB');
                e.target.value = '';
            }
        });

        // Phone number formatting
        document.getElementById('phone').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.startsWith('254')) {
                value = '0' + value.substring(3);
            }
            e.target.value = value;
        });
    </script>
</body>
</html>