@extends('layouts.app')

@section('title', 'Create Job Offer')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="{{ route('job-postings.show', $application->job_posting_id) }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Application
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-file-earmark-text"></i> Create Job Offer</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('applications.offer.store', $application) }}">
                        @csrf
                        
                        <x-form.input 
                            name="position_title" 
                            label="Position Title" 
                            required
                            :value="old('position_title', $application->jobPosting->title)" />

                        <div class="row">
                            <div class="col-md-8">
                                <x-form.input 
                                    type="number" 
                                    name="salary" 
                                    label="Salary" 
                                    required
                                    step="0.01" />
                            </div>
                            <div class="col-md-4">
                                <x-form.select 
                                    name="salary_period" 
                                    label="Period" 
                                    required
                                    :value="old('salary_period', 'monthly')"
                                    :options="[
                                        'hourly' => 'Hourly',
                                        'monthly' => 'Monthly',
                                        'annually' => 'Annually'
                                    ]" />
                            </div>
                        </div>

                        <x-form.input type="date" name="start_date" label="Start Date" required />

                        <x-form.textarea name="benefits" label="Benefits" rows="4" />

                        <x-form.textarea name="terms_and_conditions" label="Terms & Conditions" required rows="6" />

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="bi bi-check-circle"></i> Create Offer
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-person"></i> Candidate Info</h6>
                </div>
                <div class="card-body">
                    <p><strong>Name:</strong> {{ $application->full_name }}</p>
                    <p><strong>Email:</strong> {{ $application->email }}</p>
                    <p><strong>Phone:</strong> {{ $application->phone }}</p>
                    <p><strong>Position:</strong> {{ $application->jobPosting->title }}</p>
                    @if($application->jobPosting->department)
                    <p><strong>Department:</strong> {{ $application->jobPosting->department->name }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
