@extends('layouts.app')

@section('title', 'Create Job Posting')
@section('page-title', 'Create New Job Posting')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Recruitment', 'url' => route('job-postings.index')],
        ['label' => 'Create Job Posting']
    ]" />

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Create Job Posting</h5>
                </div>
                <div class="card-body">
                    @if($errors->any())
                        <x-alert type="danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-alert>
                    @endif

                    <form method="POST" action="{{ route('job-postings.store') }}">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-8">
                                <x-form.input name="title" label="Job Title" required />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select" id="status" name="status" required>
                                    <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                                    <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="department_id" class="form-label">Department <span class="text-danger">*</span></label>
                                <select class="form-select" id="department_id" name="department_id" required>
                                    <option value="">Select Department</option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}" {{ old('department_id') == $department->id ? 'selected' : '' }}>
                                            {{ $department->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="position_id" class="form-label">Position (Optional)</label>
                                <select class="form-select" id="position_id" name="position_id">
                                    <option value="">Select Position</option>
                                    @foreach($positions as $position)
                                        <option value="{{ $position->id }}" {{ old('position_id') == $position->id ? 'selected' : '' }}>
                                            {{ $position->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="location" class="form-label">Location <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="location" name="location" value="{{ old('location') }}" placeholder="e.g., Nairobi, Kenya" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="employment_type" class="form-label">Employment Type <span class="text-danger">*</span></label>
                                <select class="form-select" id="employment_type" name="employment_type" required>
                                    <option value="full-time" {{ old('employment_type') == 'full-time' ? 'selected' : '' }}>Full-time</option>
                                    <option value="part-time" {{ old('employment_type') == 'part-time' ? 'selected' : '' }}>Part-time</option>
                                    <option value="contract" {{ old('employment_type') == 'contract' ? 'selected' : '' }}>Contract</option>
                                    <option value="internship" {{ old('employment_type') == 'internship' ? 'selected' : '' }}>Internship</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="salary_range" class="form-label">Salary Range (Optional)</label>
                                <input type="text" class="form-control" id="salary_range" name="salary_range" value="{{ old('salary_range') }}" placeholder="e.g., KES 80,000 - 120,000">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="closes_at" class="form-label">Application Deadline (Optional)</label>
                                <input type="date" class="form-control" id="closes_at" name="closes_at" value="{{ old('closes_at') }}" min="{{ date('Y-m-d', strtotime('+1 day')) }}">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Job Description <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="description" name="description" rows="5" required>{{ old('description') }}</textarea>
                            <div class="form-text">Describe the role, company culture, and what makes this opportunity exciting.</div>
                        </div>

                        <div class="mb-3">
                            <label for="requirements" class="form-label">Requirements <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="requirements" name="requirements" rows="4" required>{{ old('requirements') }}</textarea>
                            <div class="form-text">List the required qualifications, skills, and experience.</div>
                        </div>

                        <div class="mb-3">
                            <label for="responsibilities" class="form-label">Key Responsibilities <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="responsibilities" name="responsibilities" rows="4" required>{{ old('responsibilities') }}</textarea>
                            <div class="form-text">Outline the main duties and responsibilities of this role.</div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('job-postings.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check"></i> Create Job Posting
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection