@extends('layouts.app')

@section('title', 'Messages - ' . $application->full_name)

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="{{ route('job-postings.show', $application->job_posting_id) }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Applications
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-chat-dots"></i> Messages with {{ $application->full_name }}</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3 pb-3 border-bottom">
                        <h6>{{ $application->jobPosting->title }}</h6>
                        <p class="text-muted small mb-0">
                            <i class="bi bi-envelope"></i> {{ $application->email }} · 
                            <i class="bi bi-phone"></i> {{ $application->phone }}
                        </p>
                    </div>

                    <div class="messages-container" style="max-height: 500px; overflow-y: auto;">
                        @forelse($messages as $message)
                        <div class="message mb-3 {{ $message->isFromCandidate() ? 'text-start' : 'text-end' }}">
                            <div class="d-inline-block" style="max-width: 75%;">
                                <div class="card {{ $message->isFromCandidate() ? 'bg-light' : 'bg-primary text-white' }}">
                                    <div class="card-body py-2 px-3">
                                        <p class="mb-1">{{ $message->message }}</p>
                                        <small class="{{ $message->isFromCandidate() ? 'text-muted' : 'text-white-50' }}">
                                            @if($message->isFromCandidate())
                                                <i class="bi bi-person"></i> {{ $application->full_name }}
                                            @else
                                                <i class="bi bi-person-badge"></i> {{ $message->sender->name ?? 'You' }}
                                            @endif
                                            · {{ $message->created_at->diffForHumans() }}
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="text-center text-muted py-5">
                            <i class="bi bi-chat-dots fs-1"></i>
                            <p class="mt-2">No messages yet. Start a conversation below!</p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-send"></i> Send Message</h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('applications.messages.store', $application) }}">
                        @csrf
                        <div class="mb-3">
                            <textarea class="form-control" name="message" rows="4" 
                                      placeholder="Type your message to the candidate..." required maxlength="2000">{{ old('message') }}</textarea>
                            <div class="form-text">Maximum 2000 characters. Candidate will receive an email notification.</div>
                            @error('message')
                            <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-send"></i> Send Message
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> Application Info</h6>
                </div>
                <div class="card-body">
                    <p><strong>Status:</strong> <span class="badge bg-primary">{{ ucfirst($application->status) }}</span></p>
                    <p><strong>Applied:</strong> {{ $application->applied_at->format('M d, Y') }}</p>
                    <p><strong>Email:</strong> {{ $application->email }}</p>
                    <p><strong>Phone:</strong> {{ $application->phone }}</p>
                    <a href="{{ route('applications.cv.download', $application) }}" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-download"></i> Download CV
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    const container = document.querySelector('.messages-container');
    if (container) {
        container.scrollTop = container.scrollHeight;
    }
</script>
@endpush
@endsection
