@extends('layouts.app')
@section('title', 'My Profile')
@section('page-title', 'My Profile')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'My Profile']
]" />

<div class="row">
    <div class="col-md-4">
        <x-info-card class="text-center">
            <x-user-avatar :user="$user" size="150" class="mb-3" />
            <h4>{{ $user->name }}</h4>
            @if($user->roles->isNotEmpty())
                <span class="badge bg-primary mb-3">{{ ucfirst($user->roles->first()->name) }}</span>
            @endif
            <p class="text-muted">{{ $user->email }}</p>

            <div class="d-grid gap-2 mt-4">
                <a href="{{ route('profile.edit') }}" class="btn btn-primary">
                    <i class="bi bi-pencil"></i> Edit Profile
                </a>
                <a href="{{ route('profile.password.edit') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-lock"></i> Change Password
                </a>
            </div>
        </x-info-card>
    </div>

    <div class="col-md-8">
        <x-info-card title="Profile Information">
            <table class="table table-borderless">
                <x-detail-row label="Full Name" :value="$user->name" />
                <x-detail-row label="Email" :value="$user->email" />
                @if($user->phone)
                <x-detail-row label="Phone" :value="$user->phone" />
                @endif
                <x-detail-row label="Role">
                    @if($user->roles->isNotEmpty())
                        <span class="badge bg-primary">{{ ucfirst($user->roles->first()->name) }}</span>
                    @else
                        <span class="badge bg-secondary">No Role Assigned</span>
                    @endif
                </x-detail-row>
                <x-detail-row label="Member Since" :value="$user->created_at->format('F d, Y')" />
            </table>

            @if($employee)
            <hr class="my-4">
            <h5 class="mb-4">Employee Information</h5>
            <table class="table table-borderless">
                <x-detail-row label="Employee Code" :value="$employee->employee_code" />
                <x-detail-row label="Department" :value="$employee->department->name ?? 'N/A'" />
                <x-detail-row label="Position" :value="$employee->position->name ?? 'N/A'" />
                <x-detail-row label="Joining Date" :value="$employee->joining_date?->format('F d, Y') ?? 'N/A'" />
                <x-detail-row label="Employment Status">
                    <x-status-badge :status="$employee->status" />
                </x-detail-row>
            </table>
            <a href="{{ route('employees.show', $employee) }}" class="btn btn-outline-primary">
                <i class="bi bi-person-badge"></i> View Full Employee Profile
            </a>
            @endif
        </x-info-card>
    </div>
</div>
@endsection
