@extends('layouts.app')
@section('title', 'Goal Details')
@section('page-title', 'Goal Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Goals', 'url' => route('performance.goals.index')],
    ['label' => 'Details']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <x-info-card>
                <div class="d-flex justify-content-between align-items-start mb-4">
                    <div>
                        <h4 class="mb-2">{{ $goal->title }}</h4>
                        <p class="text-muted mb-3">{{ $goal->description }}</p>
                        <div class="d-flex gap-2 mb-3">
                            <x-status-badge :status="$goal->status" />
                            <span class="badge bg-{{ $goal->priority_color }}">{{ ucfirst($goal->priority) }}</span>
                            <span class="badge bg-secondary">{{ ucfirst($goal->type) }}</span>
                        </div>
                    </div>
                    <div class="text-end">
                        @can('update', $goal)
                        <a href="{{ route('performance.goals.edit', $goal) }}" class="btn btn-outline-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                        @endcan
                        <a href="{{ route('performance.goals.index') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm table-borderless">
                            <x-detail-row label="Employee" :value="$goal->employee?->full_name ?? 'N/A'" />
                            <x-detail-row label="Created by" :value="$goal->createdBy?->full_name ?? 'N/A'" />
                            <x-detail-row label="Start Date" :value="$goal->start_date->format('M d, Y')" />
                            <x-detail-row label="Target Date" :value="$goal->target_date->format('M d, Y')" />
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm table-borderless">
                            <x-detail-row label="Weight" :value="$goal->weight_percentage . '%'" />
                            @if($goal->target_value)
                            <x-detail-row label="Target" :value="$goal->target_value . ' ' . $goal->measurement_unit" />
                            @endif
                            @if($goal->achieved_value)
                            <x-detail-row label="Achieved" :value="$goal->achieved_value . ' ' . $goal->measurement_unit" />
                            @endif
                            <x-detail-row label="Progress">
                                <div class="progress d-inline-block" style="width: 100px; height: 20px;">
                                    <div class="progress-bar" style="width: {{ $goal->progress_percentage }}%"></div>
                                </div>
                                {{ number_format($goal->progress_percentage, 0) }}%
                            </x-detail-row>
                        </table>
                    </div>
                </div>
            </x-info-card>

            <x-info-card title="Success Criteria" class="mb-4">
                <p>{{ $goal->success_criteria }}</p>
            </x-info-card>

            @if($goal->milestones && count($goal->milestones) > 0)
            <x-info-card title="Milestones" class="mb-4">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Milestone</th>
                                <th>Target Date</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($goal->milestones as $milestone)
                            <tr>
                                <td>{{ $milestone['title'] }}</td>
                                <td>{{ \Carbon\Carbon::parse($milestone['date'])->format('M d, Y') }}</td>
                                <td>{{ $milestone['description'] ?? 'N/A' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </x-info-card>
            @endif

            @if($goal->progressUpdates->isNotEmpty())
            <x-info-card title="Progress Updates" class="mb-4">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Progress</th>
                                <th>Notes</th>
                                <th>Updated By</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($goal->progressUpdates as $update)
                            <tr>
                                <td>{{ $update->created_at->format('M d, Y') }}</td>
                                <td>{{ $update->progress_percentage }}%</td>
                                <td>{{ $update->notes }}</td>
                                <td>{{ $update->updatedBy->full_name }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </x-info-card>
            @endif
        </div>
    </div>
</div>
@endsection
