@extends('layouts.app')

@section('title', 'Edit Performance Goal')
@section('page-title', 'Edit Performance Goal')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">Edit Performance Goal</h5>

                <form action="{{ route('performance.goals.update', $goal) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row g-3">
                        <div class="col-md-6">
                            <x-form.select 
                                name="employee_id" 
                                label="Employee" 
                                required
                                :value="$goal->employee_id"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->employee_code])->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="performance_review_id" 
                                label="Link to Performance Review"
                                :value="$goal->performance_review_id"
                                :options="$performanceReviews->mapWithKeys(fn($r) => [$r->id => $r->employee->full_name . ' - ' . $r->review_period . ' ' . $r->review_date->format('Y')])->toArray()" />
                        </div>

                        <div class="col-12">
                            <x-form.input name="title" label="Goal Title" required :value="$goal->title" placeholder="Enter goal title" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="description" label="Description" required rows="3" :value="$goal->description" placeholder="Describe the goal in detail" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="type" 
                                label="Goal Type" 
                                required
                                :value="$goal->type"
                                :options="[
                                    'individual' => 'Individual',
                                    'team' => 'Team',
                                    'company' => 'Company',
                                    'development' => 'Development',
                                    'project' => 'Project'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="priority" 
                                label="Priority" 
                                required
                                :value="$goal->priority"
                                :options="[
                                    'low' => 'Low',
                                    'medium' => 'Medium',
                                    'high' => 'High',
                                    'critical' => 'Critical'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input type="date" name="start_date" label="Start Date" required :value="$goal->start_date->format('Y-m-d')" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input type="date" name="target_date" label="Target Date" required :value="$goal->target_date->format('Y-m-d')" />
                        </div>

                        <div class="col-md-4">
                            <x-form.select 
                                name="status" 
                                label="Status" 
                                required
                                :value="$goal->status"
                                :options="[
                                    'draft' => 'Draft',
                                    'active' => 'Active',
                                    'completed' => 'Completed',
                                    'cancelled' => 'Cancelled'
                                ]" />
                        </div>

                        <div class="col-md-4">
                            <x-form.input type="number" name="weight_percentage" label="Weight (%)" required min="0" max="100" :value="$goal->weight_percentage" />
                        </div>

                        <div class="col-md-4">
                            <x-form.input type="number" name="target_value" label="Target Value" step="0.01" min="0" :value="$goal->target_value" placeholder="e.g., 100" />
                        </div>

                        <div class="col-md-12">
                            <x-form.input name="measurement_unit" label="Measurement Unit" :value="$goal->measurement_unit" placeholder="e.g., sales, projects, %" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="success_criteria" label="Success Criteria" required rows="3" :value="$goal->success_criteria" placeholder="Define what success looks like for this goal" />
                        </div>

                        <div class="col-12 mt-4">
                            <x-form.button-group 
                                cancelUrl="{{ route('performance.goals.show', $goal) }}"
                                submitText="Update Goal"
                                submitIcon="bi-check-circle" />
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
