@extends('layouts.app')

@section('title', 'Payroll Details - ' . $payroll->payroll_number)

@section('content')
<x-page-header title="Payroll Details">
    <x-slot:breadcrumbs>
        <x-breadcrumb :items="[
            ['label' => 'Dashboard', 'url' => route('dashboard')],
            ['label' => 'Payroll', 'url' => route('payroll.index')],
            ['label' => $payroll->payroll_number, 'active' => true]
        ]" />
    </x-slot:breadcrumbs>
    
    <x-slot:actions>
        <a href="{{ route('payroll.index') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back to Payroll
        </a>
        
        <button type="button" class="btn btn-outline-primary" onclick="window.print()">
            <i class="bi bi-printer"></i> Print
        </button>
        
        @if($canApprove && $payroll->approval_status === 'pending')
            <form action="{{ route('payroll.approve', $payroll) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-warning" onclick="return confirm('Approve this payroll at your level?')">
                    <i class="bi bi-check-circle"></i> Approve
                </button>
            </form>
            <button type="button" class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                <i class="bi bi-x-circle"></i> Reject
            </button>
        @endif
        
        @if($payroll->approval_status === 'approved' && $payroll->status === 'draft')
            <form action="{{ route('payroll.process', $payroll) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-info" onclick="return confirm('Process this payroll for payment?')">
                    <i class="bi bi-gear"></i> Process
                </button>
            </form>
        @endif
        
        @if($payroll->status === 'processed')
            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#markPaidModal">
                <i class="bi bi-cash-coin"></i> Mark as Paid
            </button>
        @endif
        
        @if($payroll->status === 'draft' && $payroll->approval_status === 'pending')
            <form action="{{ route('payroll.destroy', $payroll) }}" method="POST" class="d-inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger" onclick="return confirm('Delete this payroll?')">
                    <i class="bi bi-trash"></i> Delete
                </button>
            </form>
        @endif
    </x-slot:actions>
</x-page-header>

            <div class="row">
                <div class="col-md-8">
                    <!-- Employee & Payroll Info -->
                    <x-info-card title="Employee Information" icon="bi-person">
                        <div class="row">
                            <div class="col-md-6">
                                <x-detail-row label="Employee" :value="$payroll->employee->full_name" />
                                <x-detail-row label="Employee Code" :value="$payroll->employee->employee_code" />
                                <x-detail-row label="Department" :value="$payroll->employee->department->name ?? null" />
                                <x-detail-row label="Position" :value="$payroll->employee->position->name ?? null" />
                            </div>
                            <div class="col-md-6">
                                <x-detail-row label="Payroll Number">
                                    <code>{{ $payroll->payroll_number }}</code>
                                </x-detail-row>
                                <x-detail-row label="Period" :value="date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))" />
                                <x-detail-row label="Employment Type">
                                    <x-badge color="info">{{ ucfirst($payroll->employment_type) }}</x-badge>
                                </x-detail-row>
                                <x-detail-row label="Approval Status">
                                    @php
                                        $approvalColors = [
                                            'pending' => 'warning',
                                            'approved' => 'success',
                                            'rejected' => 'danger'
                                        ];
                                    @endphp
                                    <x-status-badge :status="$payroll->approval_status" />
                                </x-detail-row>
                                <x-detail-row label="Payment Status">
                                    <x-status-badge :status="$payroll->status" />
                                </x-detail-row>
                            </div>
                        </div>
                    </x-info-card>

                    <!-- Salary Breakdown -->
                    <x-info-card title="Salary Breakdown" icon="bi-cash-stack">
                        <x-stats-grid>
                            <x-stat-card 
                                title="Gross Salary" 
                                :value="'KES ' . number_format($payroll->gross_salary, 2)" 
                                color="primary" />
                            <x-stat-card 
                                title="Total Deductions" 
                                :value="'KES ' . number_format($payroll->total_deductions, 2)" 
                                color="danger" />
                            <x-stat-card 
                                title="Net Salary" 
                                :value="'KES ' . number_format($payroll->net_salary, 2)" 
                                color="success" />
                        </x-stats-grid>

                            <!-- Detailed Breakdown -->
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <h6>Earnings</h6>
                                    <x-detail-row label="Basic Salary" :value="'KES ' . number_format($payroll->basic_salary, 2)" />
                                    @if($payroll->house_allowance > 0)
                                    <x-detail-row label="House Allowance" :value="'KES ' . number_format($payroll->house_allowance, 2)" />
                                    @endif
                                    @if($payroll->transport_allowance > 0)
                                    <x-detail-row label="Transport Allowance" :value="'KES ' . number_format($payroll->transport_allowance, 2)" />
                                    @endif
                                    @if($payroll->medical_allowance > 0)
                                    <x-detail-row label="Medical Allowance" :value="'KES ' . number_format($payroll->medical_allowance, 2)" />
                                    @endif
                                    @if($payroll->overtime_pay > 0)
                                    <x-detail-row label="Overtime Pay" :value="'KES ' . number_format($payroll->overtime_pay, 2)" />
                                    @endif
                                    @if($payroll->bonuses > 0)
                                    <x-detail-row label="Bonuses" :value="'KES ' . number_format($payroll->bonuses, 2)" />
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <h6>Deductions</h6>
                                    @if($payroll->paye_tax > 0)
                                    <x-detail-row label="PAYE Tax" :value="'KES ' . number_format($payroll->paye_tax, 2)" />
                                    @endif
                                    @if($payroll->nhif_deduction > 0)
                                    <x-detail-row label="NHIF" :value="'KES ' . number_format($payroll->nhif_deduction, 2)" />
                                    @endif
                                    @if($payroll->nssf_employee > 0)
                                    <x-detail-row label="NSSF" :value="'KES ' . number_format($payroll->nssf_employee, 2)" />
                                    @endif
                                    @if($payroll->housing_levy > 0)
                                    <x-detail-row label="Housing Levy" :value="'KES ' . number_format($payroll->housing_levy, 2)" />
                                    @endif
                                    @if($payroll->withholding_tax > 0)
                                    <x-detail-row label="Withholding Tax" :value="'KES ' . number_format($payroll->withholding_tax, 2)" />
                                    @endif
                                    @if($payroll->loan_deductions > 0)
                                    <x-detail-row label="Loan Deductions" :value="'KES ' . number_format($payroll->loan_deductions, 2)" />
                                    @endif
                                </div>
                            </div>
                        </div>
                    </x-info-card>
                </div>

                <div class="col-md-4">
                    <!-- Approval Progress -->
                    @if($approvalProgress['total_levels'] > 0)
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Approval Progress</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Progress</span>
                                    <span>{{ $approvalProgress['approved_levels'] }}/{{ $approvalProgress['total_levels'] }}</span>
                                </div>
                                <div class="progress">
                                    <div class="progress-bar bg-success" role="progressbar" 
                                         style="width: {{ ($approvalProgress['approved_levels'] / $approvalProgress['total_levels']) * 100 }}%">
                                    </div>
                                </div>
                            </div>

                            <div class="list-group list-group-flush">
                                @foreach($approvalProgress['approvals'] as $approval)
                                <div class="list-group-item px-0">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <strong>Level {{ $approval->level }}</strong><br>
                                            <small class="text-muted">{{ ucwords(str_replace('_', ' ', $approval->approver_role)) }}</small>
                                            @if($approval->approver)
                                                <br><small>{{ $approval->approver->name }}</small>
                                            @endif
                                        </div>
                                        <div>
                                            @if($approval->status === 'approved')
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Approved
                                                </span>
                                            @elseif($approval->status === 'rejected')
                                                <span class="badge bg-danger">
                                                    <i class="bi bi-x-circle"></i> Rejected
                                                </span>
                                            @else
                                                <span class="badge bg-warning">
                                                    <i class="bi bi-clock"></i> Pending
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    @if($approval->comments)
                                        <div class="mt-2">
                                            <small class="text-muted">{{ $approval->comments }}</small>
                                        </div>
                                    @endif
                                    @if($approval->approved_at)
                                        <div class="mt-1">
                                            <small class="text-muted">{{ $approval->approved_at->format('M d, Y H:i') }}</small>
                                        </div>
                                    @endif
                                </div>
                                @endforeach
                            </div>

                            @if($canApprove && $payroll->approval_status === 'pending')
                                <div class="mt-3">
                                    <form action="{{ route('payroll.approve', $payroll) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-success btn-sm w-100 mb-2">
                                            <i class="bi bi-check-circle"></i> Approve
                                        </button>
                                    </form>
                                    <button type="button" class="btn btn-danger btn-sm w-100" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                        <i class="bi bi-x-circle"></i> Reject
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                    @endif

                    <!-- Tax Rules -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Tax Rules Applied</h6>
                        </div>
                        <div class="card-body">
                            <div class="list-group list-group-flush">
                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    PAYE Tax
                                    <span class="badge bg-{{ $taxRules['paye_applicable'] ? 'success' : 'secondary' }}">
                                        {{ $taxRules['paye_applicable'] ? 'Applied' : 'Not Applied' }}
                                    </span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    NHIF
                                    <span class="badge bg-{{ $taxRules['nhif_applicable'] ? 'success' : 'secondary' }}">
                                        {{ $taxRules['nhif_applicable'] ? 'Applied' : 'Not Applied' }}
                                    </span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    NSSF
                                    <span class="badge bg-{{ $taxRules['nssf_applicable'] ? 'success' : 'secondary' }}">
                                        {{ $taxRules['nssf_applicable'] ? 'Applied' : 'Not Applied' }}
                                    </span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    Housing Levy
                                    <span class="badge bg-{{ $taxRules['housing_levy_applicable'] ? 'success' : 'secondary' }}">
                                        {{ $taxRules['housing_levy_applicable'] ? 'Applied' : 'Not Applied' }}
                                    </span>
                                </div>
                                @if($taxRules['withholding_tax_applicable'])
                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    Withholding Tax
                                    <span class="badge bg-warning">{{ ($taxRules['withholding_tax_rate'] * 100) }}%</span>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Work Summary -->
                    @if($payroll->calculation_breakdown)
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">Work Summary</h6>
                            </div>
                            <div class="card-body">
                                @php $breakdown = $payroll->calculation_breakdown; @endphp
                                
                                @if(isset($breakdown['days_breakdown']))
                                <div class="mb-3">
                                    <h6 class="text-muted">Days</h6>
                                    <div class="row text-center">
                                        <div class="col-4">
                                            <div class="border-end">
                                                <strong>{{ $breakdown['days_breakdown']['days_worked'] ?? 0 }}</strong><br>
                                                <small class="text-muted">Worked</small>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="border-end">
                                                <strong>{{ $breakdown['days_breakdown']['expected_days'] ?? 0 }}</strong><br>
                                                <small class="text-muted">Expected</small>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <strong>{{ $breakdown['days_breakdown']['absent_days'] ?? 0 }}</strong><br>
                                            <small class="text-muted">Absent</small>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if(isset($breakdown['hours_breakdown']))
                                <div class="mb-3">
                                    <h6 class="text-muted">Hours</h6>
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="border-end">
                                                <strong>{{ number_format($breakdown['hours_breakdown']['regular_hours'] ?? 0, 1) }}</strong><br>
                                                <small class="text-muted">Regular</small>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <strong>{{ number_format($breakdown['hours_breakdown']['overtime_hours'] ?? 0, 1) }}</strong><br>
                                            <small class="text-muted">Overtime</small>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                <div class="text-muted">
                                    <small>Calculation Method: {{ ucwords(str_replace('_', ' ', $breakdown['calculation_method'] ?? 'Standard')) }}</small>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Mark as Paid Modal -->
@if($payroll->status === 'processed')
<div class="modal fade" id="markPaidModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('payroll.markPaid', $payroll) }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Mark Payroll as Paid</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">Payment Date</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">Payment Method</label>
                        <select class="form-select" id="payment_method" name="payment_method" required>
                            <option value="">Select Payment Method</option>
                            <option value="bank_transfer">Bank Transfer</option>
                            <option value="cash">Cash</option>
                            <option value="cheque">Cheque</option>
                            <option value="mobile_money">Mobile Money</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Mark as Paid</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('payroll.reject', $payroll) }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Reject Payroll</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="comments" class="form-label">Reason for Rejection <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="comments" name="comments" rows="4" required placeholder="Please provide a reason for rejecting this payroll..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject Payroll</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    @media print {
        .btn-group, .modal, nav, .sidebar, footer {
            display: none !important;
        }
        .card {
            border: 1px solid #dee2e6 !important;
            box-shadow: none !important;
            page-break-inside: avoid;
        }
        .card-header {
            background-color: #f8f9fa !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        body {
            background: white !important;
        }
        .container-fluid {
            padding: 0 !important;
        }
    }
</style>
@endpush