@extends('layouts.app')

@section('title', 'Generate Individual Payroll')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header title="Generate Individual Payroll" description="Create payroll for a single employee">
                <x-slot:actions>
                    <a href="{{ route('payroll.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Payroll
                    </a>
                </x-slot:actions>
            </x-page-header>

            @if($errors->any())
                <x-alert type="danger">
                    @foreach($errors->all() as $error)
                        <div>{{ $error }}</div>
                    @endforeach
                </x-alert>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Payroll Generation</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('payroll.store') }}">
                                @csrf
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <x-form.select 
                                            name="employee_id" 
                                            label="Select Employee" 
                                            required
                                            placeholder="Choose an employee..."
                                            :options="[]" />
                                                @foreach($employees as $employee)
                                                    <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                                        {{ $employee->full_name }} ({{ $employee->employee_code }})
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label for="year" class="form-label">Year</label>
                                            <select name="year" id="year" class="form-select" required>
                                                @foreach($years as $year)
                                                    <option value="{{ $year }}" {{ (old('year') ?? date('Y')) == $year ? 'selected' : '' }}>
                                                        {{ $year }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label for="month" class="form-label">Month</label>
                                            <select name="month" id="month" class="form-select" required>
                                                @foreach($months as $num => $name)
                                                    <option value="{{ $num }}" {{ (old('month') ?? date('n')) == $num ? 'selected' : '' }}>
                                                        {{ $name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle"></i>
                                    <strong>Note:</strong> Payroll will be generated based on:
                                    <ul class="mb-0 mt-2">
                                        <li>Employee's active contract and salary structure</li>
                                        <li>Attendance records for the selected period</li>
                                        <li>Employment type specific tax rules</li>
                                        <li>Applicable statutory deductions (PAYE, NHIF, NSSF, Housing Levy)</li>
                                    </ul>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <a href="{{ route('payroll.index') }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-cogs"></i> Generate Payroll
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Employee Preview -->
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Employee Preview</h6>
                        </div>
                        <div class="card-body">
                            <div id="employeePreview" class="d-none">
                                <div class="text-center mb-3">
                                    <h5 id="employeeName"></h5>
                                    <p class="text-muted mb-0" id="employeeCode"></p>
                                    <p class="text-muted" id="employeeDepartment"></p>
                                </div>
                                
                                <div class="row text-center mb-3">
                                    <div class="col-6">
                                        <div class="border-end">
                                            <span class="badge bg-info" id="employmentType"></span><br>
                                            <small class="text-muted">Employment Type</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <span class="badge bg-secondary" id="paymentFrequency"></span><br>
                                        <small class="text-muted">Payment Frequency</small>
                                    </div>
                                </div>

                                <div class="alert alert-light">
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle"></i>
                                        Contract details will be used for payroll calculation.
                                    </small>
                                </div>
                            </div>

                            <div id="noEmployeeSelected" class="text-center py-4">
                                <i class="bi bi-user-plus fa-2x text-muted mb-3"></i>
                                <p class="text-muted">Select an employee to see their details</p>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Quick Actions</h6>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="{{ route('payroll.bulk') }}" class="btn btn-outline-success btn-sm">
                                    <i class="bi bi-users"></i> Bulk Generate
                                </a>
                                <a href="{{ route('payroll.calculator') }}" class="btn btn-outline-info btn-sm">
                                    <i class="bi bi-calculator"></i> Payroll Calculator
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const employeeSelect = document.getElementById('employee_id');
    const employeePreview = document.getElementById('employeePreview');
    const noEmployeeSelected = document.getElementById('noEmployeeSelected');

    // Employee data (passed from backend)
    const employees = @json($employeesForJs);

    employeeSelect.addEventListener('change', function() {
        const selectedId = this.value;
        
        if (selectedId) {
            const employee = employees.find(emp => emp.id == selectedId);
            
            if (employee) {
                document.getElementById('employeeName').textContent = employee.name;
                document.getElementById('employeeCode').textContent = employee.code;
                document.getElementById('employeeDepartment').textContent = employee.department;
                document.getElementById('employmentType').textContent = employee.employment_type.charAt(0).toUpperCase() + employee.employment_type.slice(1);
                document.getElementById('paymentFrequency').textContent = employee.payment_frequency.charAt(0).toUpperCase() + employee.payment_frequency.slice(1);
                
                employeePreview.classList.remove('d-none');
                noEmployeeSelected.classList.add('d-none');
            }
        } else {
            employeePreview.classList.add('d-none');
            noEmployeeSelected.classList.remove('d-none');
        }
    });
});
</script>
@endpush
@endsection