@extends('layouts.app')

@section('title', 'P9 Forms')
@section('page-title', 'P9 Tax Certificates')

@section('content')
    <x-page-header 
        title="P9 Forms (Annual Tax Certificates)" 
        description="Generate and manage Kenya Revenue Authority P9 forms">
        <x-slot:actions>
            <a href="{{ route('p9-forms.bulk-create') }}" class="btn btn-success me-2">
                <i class="bi bi-files"></i> Bulk Generate
            </a>
            <a href="{{ route('p9-forms.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Generate P9
            </a>
        </x-slot:actions>
    </x-page-header>

    <x-alert type="success" :message="session('success')" />
    
    @if($errors->any())
        <x-alert type="danger">
            @foreach($errors->all() as $error)
                {{ $error }}<br>
            @endforeach
        </x-alert>
    @endif

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">
                <form method="GET" action="{{ route('p9-forms.index') }}" class="row g-3 mb-4">
                    <div class="col-md-4">
                        <label class="form-label">Employee</label>
                        <select class="form-select" name="employee">
                            <option value="">All Employees</option>
                            @foreach($employees as $emp)
                                <option value="{{ $emp->id }}" {{ request('employee') == $emp->id ? 'selected' : '' }}>
                                    {{ $emp->full_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Year</label>
                        <select class="form-select" name="year">
                            <option value="">All Years</option>
                            @foreach($years as $year)
                                <option value="{{ $year }}" {{ request('year', now()->year) == $year ? 'selected' : '' }}>
                                    {{ $year }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1">
                            <i class="bi bi-search"></i> Filter
                        </button>
                        <a href="{{ route('p9-forms.index') }}" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i>
                        </a>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Employee</th>
                                <th>Year</th>
                                <th>Total Gross Pay</th>
                                <th>Total PAYE</th>
                                <th>Total NHIF</th>
                                <th>Total NSSF</th>
                                <th>Net PAYE</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($p9Forms as $p9Form)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($p9Form->employee->photo)
                                                <img src="{{ asset('storage/' . $p9Form->employee->photo) }}"
                                                     alt="{{ $p9Form->employee->full_name }}"
                                                     class="rounded-circle me-2"
                                                     style="width: 32px; height: 32px; object-fit: cover;">
                                            @else
                                                <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center me-2"
                                                     style="width: 32px; height: 32px; font-size: 12px;">
                                                    {{ substr($p9Form->employee->first_name, 0, 1) }}{{ substr($p9Form->employee->last_name, 0, 1) }}
                                                </div>
                                            @endif
                                            <div>
                                                <a href="{{ route('employees.show', $p9Form->employee) }}">
                                                    {{ $p9Form->employee->full_name }}
                                                </a>
                                                <br>
                                                <small class="text-muted">{{ $p9Form->kra_pin ?? 'No KRA PIN' }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td><strong>{{ $p9Form->year }}</strong></td>
                                    <td>Ksh{{ number_format($p9Form->total_gross_pay, 2) }}</td>
                                    <td>Ksh{{ number_format($p9Form->total_paye_tax, 2) }}</td>
                                    <td>Ksh{{ number_format($p9Form->total_nhif, 2) }}</td>
                                    <td>Ksh{{ number_format($p9Form->total_nssf, 2) }}</td>
                                    <td><strong class="text-danger">Ksh{{ number_format($p9Form->net_paye, 2) }}</strong></td>
                                    <td>
                                        <span class="badge badge-status-{{ $p9Form->status }}">
                                            {{ ucfirst($p9Form->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('p9-forms.show', $p9Form) }}" class="btn btn-outline-primary" title="View P9">
                                                <i class="bi bi-file-text"></i>
                                            </a>
                                            <a href="{{ route('p9-forms.pdf', $p9Form) }}" class="btn btn-outline-success" title="Download PDF">
                                                <i class="bi bi-download"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="bi bi-file-earmark-text" style="font-size: 48px; color: #ccc;"></i>
                                        <p class="text-muted mt-3 mb-0">No P9 forms found</p>
                                        <small class="text-muted">Generate P9 forms from payroll records</small>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if($p9Forms->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $p9Forms->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection