@extends('layouts.app')

@section('title', 'Generate P9 Form')
@section('page-title', 'Generate P9 Form')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'P9 Forms', 'url' => route('p9-forms.index')],
        ['label' => 'Generate']
    ]" />

    <div class="row">
        <div class="col-md-6 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">Generate P9 Tax Certificate</h5>

                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    P9 forms are generated from existing payroll records. Ensure payroll has been processed for the selected year.
                </div>

                <form action="{{ route('p9-forms.generate') }}" method="POST">
                    @csrf
                        <label for="employee_id" class="form-label">Employee <span class="text-danger">*</span></label>
                        <select class="form-select @error('employee_id') is-invalid @enderror"
                                id="employee_id" name="employee_id" required>
                            <option value="">Select Employee</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}"
                                        data-kra-pin="{{ $employee->kra_pin }}"
                                        {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                    {{ $employee->full_name }} ({{ $employee->employee_code }})
                                    @if($employee->kra_pin)
                                        - KRA: {{ $employee->kra_pin }}
                                    @else
                                        - <span class="text-warning">No KRA PIN</span>
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        @error('employee_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="year" class="form-label">Tax Year <span class="text-danger">*</span></label>
                        <select class="form-select @error('year') is-invalid @enderror"
                                id="year" name="year" required>
                            @foreach($years as $year)
                                <option value="{{ $year }}" {{ old('year', now()->year - 1) == $year ? 'selected' : '' }}>
                                    {{ $year }}
                                </option>
                            @endforeach
                        </select>
                        @error('year')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Select the tax year for which to generate the P9 form</small>
                    </div>

                    <div class="alert alert-warning">
                        <h6><i class="bi bi-exclamation-triangle me-2"></i>Requirements:</h6>
                        <ul class="mb-0">
                            <li>Employee must have a valid KRA PIN</li>
                            <li>Payroll records must exist for the selected year</li>
                            <li>All statutory deductions must be properly calculated</li>
                        </ul>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-file-earmark-plus"></i> Generate P9 Form
                        </button>
                        <a href="{{ route('p9-forms.index') }}" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    document.getElementById('employee_id').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const kraPin = selectedOption.getAttribute('data-kra-pin');
        
        if (this.value && !kraPin) {
            alert('Warning: Selected employee does not have a KRA PIN. Please update employee information before generating P9 form.');
        }
    });
</script>
@endpush