@extends('layouts.app')

@section('title', 'Subscription Required')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card border-danger">
                <div class="card-header bg-danger text-white">
                    <h4 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Subscription Required</h4>
                </div>
                <div class="card-body text-center py-5">
                    <i class="bi bi-lock text-danger" style="font-size: 4rem;"></i>
                    <h3 class="mt-3">Active Subscription Required</h3>
                    <p class="lead text-muted">
                        You need an active subscription to access this feature. Please choose a plan below to continue.
                    </p>
                </div>
            </div>

            <!-- Subscription Plans -->
            <div class="row mt-4">
                @foreach($plans as $plan)
                <div class="col-md-4 mb-4">
                    <div class="card h-100 {{ $plan->slug === 'professional' ? 'border-primary' : '' }}">
                        @if($plan->slug === 'professional')
                        <div class="card-header bg-primary text-white text-center">
                            <span class="badge bg-light text-primary">RECOMMENDED</span>
                        </div>
                        @endif
                        <div class="card-body d-flex flex-column">
                            <h4 class="card-title">{{ $plan->name }}</h4>
                            <p class="text-muted">{{ $plan->description }}</p>
                            
                            <div class="mb-3">
                                <h2 class="text-primary">
                                    KES {{ number_format($plan->price_monthly, 0) }}
                                    <small class="text-muted fs-6">/month</small>
                                </h2>
                                <p class="text-muted mb-0">
                                    <small>or KES {{ number_format($plan->price_annual, 0) }}/year</small>
                                </p>
                            </div>

                            <ul class="list-unstyled mb-4">
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    {{ $plan->max_employees ?? 'Unlimited' }} Employees
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    {{ $plan->max_users ?? 'Unlimited' }} Users
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    {{ $plan->max_departments ?? 'Unlimited' }} Departments
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    {{ $plan->storage_limit_gb ?? 'Unlimited' }} GB Storage
                                </li>
                                @if($plan->features['api_access'] ?? false)
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    API Access
                                </li>
                                @endif
                                @if($plan->features['white_label'] ?? false)
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    White Label
                                </li>
                                @endif
                                @if($plan->features['priority_support'] ?? false)
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success"></i>
                                    Priority Support
                                </li>
                                @endif
                            </ul>

                            <div class="mt-auto">
                                <a href="{{ route('subscription.upgrade', $plan) }}" 
                                   class="btn {{ $plan->slug === 'professional' ? 'btn-primary' : 'btn-outline-primary' }} w-100">
                                    <i class="bi bi-star"></i> Get Started
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <div class="card mt-4">
                <div class="card-body">
                    <h5><i class="bi bi-info-circle"></i> All Plans Include:</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <ul>
                                <li>14-day free trial</li>
                                <li>No credit card required for trial</li>
                                <li>Cancel anytime</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul>
                                <li>Email support</li>
                                <li>Regular updates</li>
                                <li>Data security & backups</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="text-center mt-4">
                <p class="text-muted">
                    Questions? <a href="mailto:support@qayahrm.com">Contact our support team</a>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection
