@extends('layouts.app')

@section('title', 'Invoices & Payments')

@section('content')
<div class="container-fluid">
    <x-page-header 
        title="Invoices & Payments" 
        description="View and manage your organization's invoices and payment history"
        icon="receipt" />

    <x-alert type="success" :message="session('success')" />

    <!-- Summary Cards -->
    <x-stats-grid :stats="[
        ['value' => 'KES ' . number_format($summary['total_paid'], 2), 'label' => 'Total Paid', 'icon' => 'check-circle', 'type' => 'primary'],
        ['value' => 'KES ' . number_format($summary['total_pending'], 2), 'label' => 'Pending', 'icon' => 'clock', 'type' => 'warning'],
        ['value' => $summary['invoice_count'], 'label' => 'Total Invoices', 'icon' => 'receipt', 'type' => 'info'],
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h6 class="card-title">Last Payment</h6>
                    <h3>
                        @if($summary['last_payment'])
                            KES {{ number_format($summary['last_payment']['amount'], 2) }}
                        @else
                            -
                        @endif
                    </h3>
                    @if($summary['last_payment'])
                        <small>{{ $summary['last_payment']['date'] }}</small>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Invoices Table -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">All Invoices</h5>
        </div>
        <div class="card-body">
            @if($invoices->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Issue Date</th>
                                <th>Due Date</th>
                                <th>Description</th>
                                <th class="text-end">Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoices as $invoice)
                            <tr>
                                <td><strong>{{ $invoice->invoice_number }}</strong></td>
                                <td>{{ $invoice->issue_date->format('M d, Y') }}</td>
                                <td>{{ $invoice->due_date->format('M d, Y') }}</td>
                                <td>
                                    @if(count($invoice->line_items) > 0)
                                        {{ $invoice->line_items[0]['description'] }}
                                        @if(count($invoice->line_items) > 1)
                                            <small class="text-muted">(+{{ count($invoice->line_items) - 1 }} more)</small>
                                        @endif
                                    @endif
                                </td>
                                <td class="text-end"><strong>KES {{ number_format($invoice->total, 2) }}</strong></td>
                                <td>
                                    @if($invoice->status === 'paid')
                                        <span class="badge bg-success">Paid</span>
                                    @elseif($invoice->status === 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($invoice->status === 'overdue')
                                        <span class="badge bg-danger">Overdue</span>
                                    @else
                                        <span class="badge bg-secondary">{{ ucfirst($invoice->status) }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($invoice->status === 'pending' || $invoice->status === 'overdue')
                                        <a href="{{ route('organization.payments.show', $invoice) }}" class="btn btn-sm btn-success">
                                            <i class="bi bi-credit-card"></i> Pay Now
                                        </a>
                                    @else
                                        <a href="{{ route('organization.payments.show', $invoice) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-eye"></i> View
                                        </a>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $invoices->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-receipt text-muted" style="font-size: 3rem;"></i>
                    <p class="text-muted mt-3">No invoices yet</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
