@extends('layouts.app')

@section('title', 'Payment History')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2><i class="bi bi-clock-history"></i> Payment History</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('organization.payments.index') }}">Invoices & Payments</a></li>
                    <li class="breadcrumb-item active">Payment History</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">All Payments</h5>
                <a href="{{ route('organization.payments.index') }}" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-arrow-left"></i> Back to Invoices
                </a>
            </div>
        </div>
        <div class="card-body">
            @if($payments->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Invoice</th>
                                <th>Method</th>
                                <th>Transaction ID</th>
                                <th>M-Pesa Receipt</th>
                                <th class="text-end">Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($payments as $payment)
                            <tr>
                                <td>
                                    @if($payment->completed_at)
                                        {{ $payment->completed_at->format('M d, Y H:i') }}
                                    @elseif($payment->initiated_at)
                                        {{ $payment->initiated_at->format('M d, Y H:i') }}
                                    @else
                                        {{ $payment->created_at->format('M d, Y H:i') }}
                                    @endif
                                </td>
                                <td>
                                    @if($payment->invoice)
                                        <a href="{{ route('organization.payments.show', $payment->invoice) }}">
                                            {{ $payment->invoice->invoice_number }}
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>
                                    @if($payment->payment_method === 'mpesa')
                                        <i class="bi bi-phone text-success"></i> M-Pesa
                                    @else
                                        {{ ucfirst($payment->payment_method) }}
                                    @endif
                                </td>
                                <td>
                                    <small class="font-monospace">{{ $payment->transaction_id ?? '-' }}</small>
                                </td>
                                <td>
                                    @if($payment->mpesa_receipt_number)
                                        <span class="badge bg-success">{{ $payment->mpesa_receipt_number }}</span>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-end">
                                    <strong>{{ $payment->currency }} {{ number_format($payment->amount, 2) }}</strong>
                                </td>
                                <td>
                                    @if($payment->status === 'completed')
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle"></i> Completed
                                        </span>
                                    @elseif($payment->status === 'pending')
                                        <span class="badge bg-warning">
                                            <i class="bi bi-clock"></i> Pending
                                        </span>
                                    @elseif($payment->status === 'failed')
                                        <span class="badge bg-danger">
                                            <i class="bi bi-x-circle"></i> Failed
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">{{ ucfirst($payment->status) }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($payment->status === 'pending')
                                        <form method="POST" action="{{ route('organization.payments.query', $payment) }}" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-outline-primary" title="Check Status">
                                                <i class="bi bi-arrow-clockwise"></i>
                                            </button>
                                        </form>
                                    @endif
                                    
                                    @if($payment->invoice)
                                        <a href="{{ route('organization.payments.show', $payment->invoice) }}" 
                                           class="btn btn-sm btn-outline-secondary" 
                                           title="View Invoice">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-light">
                                <td colspan="5" class="text-end"><strong>Total Paid:</strong></td>
                                <td class="text-end">
                                    <strong>
                                        KES {{ number_format($payments->where('status', 'completed')->sum('amount'), 2) }}
                                    </strong>
                                </td>
                                <td colspan="2"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $payments->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-clock-history text-muted" style="font-size: 3rem;"></i>
                    <p class="text-muted mt-3">No payment history yet</p>
                    <p class="text-muted">Payments will appear here once you make your first payment</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Payment Statistics -->
    @if($payments->count() > 0)
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h6 class="card-title">Completed Payments</h6>
                    <h3>{{ $payments->where('status', 'completed')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h6 class="card-title">Pending Payments</h6>
                    <h3>{{ $payments->where('status', 'pending')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h6 class="card-title">Failed Payments</h6>
                    <h3>{{ $payments->where('status', 'failed')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h6 class="card-title">Total Amount</h6>
                    <h3>KES {{ number_format($payments->sum('amount'), 0) }}</h3>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Help Section -->
    <div class="card mt-4 border-info">
        <div class="card-body">
            <h6><i class="bi bi-info-circle text-info"></i> About Payment History</h6>
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Payment Status:</strong></p>
                    <ul class="small">
                        <li><span class="badge bg-success">Completed</span> - Payment successfully processed</li>
                        <li><span class="badge bg-warning">Pending</span> - Payment initiated, awaiting confirmation</li>
                        <li><span class="badge bg-danger">Failed</span> - Payment was unsuccessful</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <p><strong>Need Help?</strong></p>
                    <ul class="small">
                        <li>For pending payments, click the refresh icon to check status</li>
                        <li>Failed payments can be retried from the invoice page</li>
                        <li>Contact support if you have questions about a payment</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
