<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Date & Time</th>
                <th>User</th>
                <th>Event</th>
                <th>Category</th>
                <th>Severity</th>
                <th>Description</th>
                <th>IP Address</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($logs as $log)
                <tr>
                    <td>
                        <small>{{ $log->created_at->format('Y-m-d H:i:s') }}</small>
                    </td>
                    <td>
                        @if($log->user)
                            <div class="d-flex align-items-center">
                                <div>
                                    <strong>{{ $log->user->name }}</strong><br>
                                    <small class="text-muted">{{ $log->user->email }}</small>
                                </div>
                            </div>
                        @else
                            <span class="text-muted">System</span>
                        @endif
                    </td>
                    <td>
                        <code>{{ $log->event_type }}</code>
                    </td>
                    <td>
                        <span class="badge bg-{{ $log->category_color }}">
                            {{ ucfirst(str_replace('_', ' ', $log->category)) }}
                        </span>
                    </td>
                    <td>
                        <span class="badge bg-{{ $log->severity_color }}">
                            {{ ucfirst($log->severity) }}
                        </span>
                    </td>
                    <td>
                        <div style="max-width: 400px;">
                            {{ Str::limit($log->description, 120) }}
                            @if($log->auditable_type)
                                <br><small class="text-muted">{{ $log->model_name }} #{{ $log->auditable_id }}</small>
                            @endif
                        </div>
                    </td>
                    <td>
                        <small>{{ $log->ip_address }}</small>
                    </td>
                    <td>
                        <a href="{{ route('organization.audit-logs.show', $log) }}" 
                           class="btn btn-sm btn-outline-primary" 
                           title="View Details">
                            <i class="bi bi-eye"></i>
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" class="text-center py-4">
                        <div class="d-flex flex-column align-items-center">
                            <i class="bi bi-inbox fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No audit records found</h5>
                            <p class="text-muted">Try adjusting your filters or date range.</p>
                        </div>
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

@if($logs->hasPages())
    <div class="d-flex justify-content-between align-items-center mt-3">
        <div>
            <small class="text-muted">
                Showing {{ $logs->firstItem() }} to {{ $logs->lastItem() }} of {{ $logs->total() }} results
            </small>
        </div>
        <div>
            {{ $logs->links() }}
        </div>
    </div>
@endif