@extends('layouts.app')

@section('title', 'Organization Audit Dashboard')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Audit Dashboard</h2>
                <div>
                    <select class="form-select d-inline-block w-auto" id="daysFilter">
                        <option value="7" {{ $days == 7 ? 'selected' : '' }}>Last 7 days</option>
                        <option value="30" {{ $days == 30 ? 'selected' : '' }}>Last 30 days</option>
                        <option value="90" {{ $days == 90 ? 'selected' : '' }}>Last 90 days</option>
                    </select>
                    <a href="{{ route('organization.audit-logs.index') }}" class="btn btn-primary ms-2">
                        <i class="bi bi-list"></i> View All Logs
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ number_format($statistics['total_activities']) }}</h4>
                            <p class="mb-0">Total Activities</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-list fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $topUsers->count() }}</h4>
                            <p class="mb-0">Active Users</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $criticalActivities->count() }}</h4>
                            <p class="mb-0">Critical Events</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-exclamation-triangle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $complianceActivities->count() }}</h4>
                            <p class="mb-0">Compliance Events</p>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-clipboard-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Critical Activities -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Recent Critical Activities</h5>
                </div>
                <div class="card-body">
                    @forelse($criticalActivities as $activity)
                        <div class="d-flex justify-content-between align-items-center mb-3 p-2 border-start border-warning border-3">
                            <div>
                                <strong>{{ $activity->description }}</strong><br>
                                <small class="text-muted">
                                    {{ $activity->user ? $activity->user->name : 'System' }} • 
                                    {{ $activity->created_at->diffForHumans() }}
                                </small>
                            </div>
                            <span class="badge bg-{{ $activity->severity_color }}">{{ ucfirst($activity->severity) }}</span>
                        </div>
                    @empty
                        <p class="text-muted text-center">No critical activities in the selected period.</p>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Top Active Users -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Most Active Users</h5>
                </div>
                <div class="card-body">
                    @forelse($topUsers as $userActivity)
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <strong>{{ $userActivity->user->name }}</strong><br>
                                <small class="text-muted">{{ $userActivity->user->email }}</small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">{{ number_format($userActivity->activity_count) }} activities</span>
                            </div>
                        </div>
                    @empty
                        <p class="text-muted text-center">No user activity data available.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Department Statistics -->
    @if(!empty($departmentStats))
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Department Activity</h5>
                </div>
                <div class="card-body">
                    @foreach($departmentStats as $deptStat)
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <strong>{{ $deptStat['department']->name }}</strong>
                            </div>
                            <div>
                                <span class="badge bg-secondary">{{ number_format($deptStat['activity_count']) }} activities</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Compliance Activities -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Recent Compliance Activities</h5>
                </div>
                <div class="card-body">
                    @forelse($complianceActivities as $compliance)
                        <div class="mb-3 p-2 border-start border-info border-3">
                            <strong>{{ $compliance->description }}</strong><br>
                            <small class="text-muted">
                                {{ $compliance->user ? $compliance->user->name : 'System' }} • 
                                {{ $compliance->created_at->diffForHumans() }}
                            </small>
                        </div>
                    @empty
                        <p class="text-muted text-center">No compliance activities in the selected period.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Activity Categories Chart -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Activity Categories</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($statistics['by_category'] as $category => $count)
                            <div class="col-md-2 col-sm-4 col-6 mb-3">
                                <div class="text-center">
                                    <h4 class="text-primary">{{ $count }}</h4>
                                    <p class="mb-0 small">{{ ucfirst(str_replace('_', ' ', $category)) }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#daysFilter').on('change', function() {
        const days = $(this).val();
        window.location.href = '{{ route("organization.audit-logs.dashboard") }}?days=' + days;
    });
});
</script>
@endpush