@extends('onboarding.layout')

@section('title', 'Welcome')

@section('content')
<div class="step-indicator">
    <div class="step active">
        <div class="step-circle">1</div>
        <div class="step-label">Welcome</div>
    </div>
    <div class="step">
        <div class="step-circle">2</div>
        <div class="step-label">Select Plan</div>
    </div>
    <div class="step">
        <div class="step-circle">3</div>
        <div class="step-label">Payment</div>
    </div>
    <div class="step">
        <div class="step-circle">4</div>
        <div class="step-label">Complete</div>
    </div>
</div>

<div class="text-center mb-4">
    <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
    <h3 class="mt-3">Email Verified Successfully!</h3>
    <p class="text-muted">Welcome to Qaya HRM, {{ $user->name }}</p>
</div>

<div class="card mb-4">
    <div class="card-body">
        <h5><i class="bi bi-building"></i> Your Organization</h5>
        <div class="row mt-3">
            <div class="col-md-6">
                <p><strong>Organization Name:</strong><br>{{ $organization->name }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Your Role:</strong><br>Organization Administrator</p>
            </div>
        </div>
    </div>
</div>

<div class="alert alert-info">
    <h6><i class="bi bi-info-circle"></i> What's Next?</h6>
    <p class="mb-0">
        In the next step, you'll choose a subscription plan that best fits your organization's needs. 
        You can start with a 14-day free trial or subscribe immediately.
    </p>
</div>

<div class="card mb-4">
    <div class="card-body">
        <h6>What You'll Get:</h6>
        <div class="row">
            <div class="col-md-6">
                <ul>
                    <li>Employee Management</li>
                    <li>Attendance Tracking</li>
                    <li>Leave Management</li>
                    <li>Payroll Processing</li>
                </ul>
            </div>
            <div class="col-md-6">
                <ul>
                    <li>Performance Reviews</li>
                    <li>Training Management</li>
                    <li>Reports & Analytics</li>
                    <li>And much more!</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="d-grid">
    <a href="{{ route('onboarding.select-plan') }}" class="btn btn-primary btn-lg">
        <i class="bi bi-arrow-right"></i> Continue to Plan Selection
    </a>
</div>
@endsection
