@extends('layouts.app')

@section('title', 'Create Employee Loan')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">Create Employee Loan</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('loans.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="employee_id" 
                                    label="Employee" 
                                    required
                                    placeholder="Select Employee"
                                    :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' (' . $e->employee_code . ')'])->toArray()" />
                            </div>

                            <div class="col-md-6">
                                <x-form.select 
                                    name="loan_type" 
                                    label="Loan Type" 
                                    required
                                    placeholder="Select Type"
                                    :options="[
                                        'salary_advance' => 'Salary Advance',
                                        'emergency' => 'Emergency',
                                        'personal' => 'Personal',
                                        'education' => 'Education',
                                        'housing' => 'Housing',
                                        'other' => 'Other'
                                    ]" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <x-form.input 
                                    name="principal_amount" 
                                    type="number" 
                                    label="Principal Amount (KES)" 
                                    required
                                    step="0.01"
                                    min="1" />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="interest_rate" class="form-label">Interest Rate (% Annual) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('interest_rate') is-invalid @enderror" 
                                       id="interest_rate" name="interest_rate" 
                                       value="{{ old('interest_rate', 0) }}" 
                                       step="0.01" min="0" max="100" required>
                                @error('interest_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">Enter 0 for interest-free loans</small>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="repayment_period_months" class="form-label">Repayment Period (Months) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('repayment_period_months') is-invalid @enderror" 
                                       id="repayment_period_months" name="repayment_period_months" 
                                       value="{{ old('repayment_period_months', 12) }}" 
                                       min="1" max="60" required>
                                @error('repayment_period_months')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="disbursement_date" class="form-label">Disbursement Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('disbursement_date') is-invalid @enderror" 
                                       id="disbursement_date" name="disbursement_date" 
                                       value="{{ old('disbursement_date', date('Y-m-d')) }}" required>
                                @error('disbursement_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="first_deduction_date" class="form-label">First Deduction Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('first_deduction_date') is-invalid @enderror" 
                                       id="first_deduction_date" name="first_deduction_date" 
                                       value="{{ old('first_deduction_date', date('Y-m-d', strtotime('+1 month'))) }}" required>
                                @error('first_deduction_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="purpose" class="form-label">Purpose</label>
                            <textarea class="form-control @error('purpose') is-invalid @enderror" 
                                      id="purpose" name="purpose" rows="3" 
                                      placeholder="Describe the purpose of this loan...">{{ old('purpose') }}</textarea>
                            @error('purpose')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="terms_conditions" class="form-label">Terms & Conditions</label>
                            <textarea class="form-control @error('terms_conditions') is-invalid @enderror" 
                                      id="terms_conditions" name="terms_conditions" rows="4" 
                                      placeholder="Enter any terms and conditions for this loan...">{{ old('terms_conditions') }}</textarea>
                            @error('terms_conditions')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-end">
                            <a href="{{ route('loans.index') }}" class="btn btn-secondary me-2">Cancel</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save"></i> Create Loan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
