@extends('layouts.app')

@section('title', 'Loan Policy Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header title="Loan Policy Settings" description="Configure loan policies and limits">
                <x-slot:actions>
                    <a href="{{ route('loan-settings.edit') }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Settings
                    </a>
                    <form action="{{ route('loan-settings.reset') }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-warning" onclick="return confirm('Reset all settings to defaults?')">
                            <i class="fas fa-undo"></i> Reset to Defaults
                        </button>
                    </form>
                </x-slot:actions>
            </x-page-header>

            <x-alert type="success" :message="session('success')" />

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Loan Limits -->
                        <div class="col-md-6">
                            <h5 class="text-primary">Loan Limits & Eligibility</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Maximum Loan Amount:</td>
                                    <td><strong>KES {{ number_format($settings->max_loan_amount, 2) }}</strong></td>
                                </tr>
                                <tr>
                                    <td>Maximum Loan Term:</td>
                                    <td><strong>{{ $settings->max_loan_term_months }} months</strong></td>
                                </tr>
                                <tr>
                                    <td>Minimum Employment Tenure:</td>
                                    <td><strong>{{ $settings->min_employment_tenure_months }} months</strong></td>
                                </tr>
                                <tr>
                                    <td>Maximum Outstanding Loans:</td>
                                    <td><strong>{{ $settings->max_outstanding_loans }}</strong></td>
                                </tr>
                                <tr>
                                    <td>Loan-to-Salary Ratio:</td>
                                    <td><strong>{{ $settings->loan_to_salary_ratio }}x monthly salary</strong></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Interest Rates by Loan Type</h6>
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Loan Type</th>
                                        <th>Interest Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($settings->default_interest_rates as $type => $rate)
                                    <tr>
                                        <td>{{ ucwords(str_replace('_', ' ', $type)) }}</td>
                                        <td><strong>{{ $rate }}% per year</strong></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Approval Settings -->
                        <div class="col-md-6">
                            <h5 class="text-success">Approval Settings</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Auto-Approve Below:</td>
                                    <td><strong>KES {{ number_format($settings->auto_approve_below_amount, 2) }}</strong></td>
                                </tr>
                                <tr>
                                    <td>Require Guarantor Above:</td>
                                    <td><strong>KES {{ number_format($settings->require_guarantor_above_amount, 2) }}</strong></td>
                                </tr>
                                <tr>
                                    <td>CEO Approval Threshold:</td>
                                    <td><strong>KES {{ number_format($settings->ceo_approval_threshold, 2) }}</strong></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Approval Workflow</h6>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Department Head Approval
                                    <span class="badge bg-{{ $settings->require_department_head_approval ? 'success' : 'secondary' }}">
                                        {{ $settings->require_department_head_approval ? 'Required' : 'Optional' }}
                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Finance Approval
                                    <span class="badge bg-{{ $settings->require_finance_approval ? 'success' : 'secondary' }}">
                                        {{ $settings->require_finance_approval ? 'Required' : 'Optional' }}
                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    CEO Approval (Above Threshold)
                                    <span class="badge bg-{{ $settings->require_ceo_approval_above_threshold ? 'success' : 'secondary' }}">
                                        {{ $settings->require_ceo_approval_above_threshold ? 'Required' : 'Optional' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <!-- Loan Policies -->
                        <div class="col-md-6">
                            <h5 class="text-warning">Loan Policies</h5>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Multiple Loans
                                    <span class="badge bg-{{ $settings->allow_multiple_loans ? 'success' : 'danger' }}">
                                        {{ $settings->allow_multiple_loans ? 'Yes' : 'No' }}
                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Loan with Pending Loan
                                    <span class="badge bg-{{ $settings->allow_loan_with_pending_loan ? 'success' : 'danger' }}">
                                        {{ $settings->allow_loan_with_pending_loan ? 'Yes' : 'No' }}
                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Early Repayment
                                    <span class="badge bg-{{ $settings->allow_early_repayment ? 'success' : 'danger' }}">
                                        {{ $settings->allow_early_repayment ? 'Yes' : 'No' }}
                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Allow Payment Holidays
                                    <span class="badge bg-{{ $settings->allow_payment_holidays ? 'success' : 'danger' }}">
                                        {{ $settings->allow_payment_holidays ? 'Yes' : 'No' }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Repayment & Notifications -->
                        <div class="col-md-6">
                            <h5 class="text-info">Repayment & Notifications</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td>Maximum Payment Holidays:</td>
                                    <td><strong>{{ $settings->max_payment_holidays }}</strong></td>
                                </tr>
                                <tr>
                                    <td>Early Repayment Penalty:</td>
                                    <td><strong>{{ $settings->early_repayment_penalty_rate }}%</strong></td>
                                </tr>
                                <tr>
                                    <td>Notification Days Before Deduction:</td>
                                    <td><strong>{{ $settings->notification_days_before }} days</strong></td>
                                </tr>
                            </table>

                            <h6 class="text-secondary mt-3">Notifications</h6>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Notify on Approval
                                    <span class="badge bg-{{ $settings->notify_on_approval ? 'success' : 'secondary' }}">
                                        {{ $settings->notify_on_approval ? 'Enabled' : 'Disabled' }}
                                    </span>
                                </div>
                                <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                                    Notify Before Deduction
                                    <span class="badge bg-{{ $settings->notify_before_deduction ? 'success' : 'secondary' }}">
                                        {{ $settings->notify_before_deduction ? 'Enabled' : 'Disabled' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($settings->terms_and_conditions)
                    <div class="row mt-4">
                        <div class="col-12">
                            <h5 class="text-secondary">Terms & Conditions</h5>
                            <div class="card bg-light">
                                <div class="card-body">
                                    <p class="mb-0">{{ $settings->terms_and_conditions }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
