@extends('layouts.app')

@section('title', 'Edit Loan Policy Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Loan Policy Settings</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('loan-settings.update') }}" method="POST">
                        @csrf
                        @method('PUT')

                        <!-- Loan Limits & Eligibility -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">Loan Limits & Eligibility</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="max_loan_amount" class="form-label">Maximum Loan Amount (KES)</label>
                                    <input type="number" class="form-control @error('max_loan_amount') is-invalid @enderror" 
                                           id="max_loan_amount" name="max_loan_amount" 
                                           value="{{ old('max_loan_amount', $settings->max_loan_amount) }}" 
                                           step="0.01" min="1" required>
                                    @error('max_loan_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="max_loan_term_months" class="form-label">Maximum Loan Term (Months)</label>
                                    <input type="number" class="form-control @error('max_loan_term_months') is-invalid @enderror" 
                                           id="max_loan_term_months" name="max_loan_term_months" 
                                           value="{{ old('max_loan_term_months', $settings->max_loan_term_months) }}" 
                                           min="1" max="120" required>
                                    @error('max_loan_term_months')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="min_employment_tenure_months" class="form-label">Minimum Employment Tenure (Months)</label>
                                    <input type="number" class="form-control @error('min_employment_tenure_months') is-invalid @enderror" 
                                           id="min_employment_tenure_months" name="min_employment_tenure_months" 
                                           value="{{ old('min_employment_tenure_months', $settings->min_employment_tenure_months) }}" 
                                           min="0" max="60" required>
                                    @error('min_employment_tenure_months')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="max_outstanding_loans" class="form-label">Maximum Outstanding Loans</label>
                                    <input type="number" class="form-control @error('max_outstanding_loans') is-invalid @enderror" 
                                           id="max_outstanding_loans" name="max_outstanding_loans" 
                                           value="{{ old('max_outstanding_loans', $settings->max_outstanding_loans) }}" 
                                           min="1" max="10" required>
                                    @error('max_outstanding_loans')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="loan_to_salary_ratio" class="form-label">Loan-to-Salary Ratio</label>
                                    <input type="number" class="form-control @error('loan_to_salary_ratio') is-invalid @enderror" 
                                           id="loan_to_salary_ratio" name="loan_to_salary_ratio" 
                                           value="{{ old('loan_to_salary_ratio', $settings->loan_to_salary_ratio) }}" 
                                           step="0.1" min="0.1" max="10" required>
                                    <small class="text-muted">Times monthly salary</small>
                                    @error('loan_to_salary_ratio')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Interest Rates by Loan Type -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">Interest Rates by Loan Type (%)</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_salary_advance" class="form-label">Salary Advance</label>
                                    <input type="number" class="form-control @error('interest_salary_advance') is-invalid @enderror" 
                                           id="interest_salary_advance" name="interest_salary_advance" 
                                           value="{{ old('interest_salary_advance', $settings->default_interest_rates['salary_advance'] ?? 0) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('interest_salary_advance')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_emergency" class="form-label">Emergency</label>
                                    <input type="number" class="form-control @error('interest_emergency') is-invalid @enderror" 
                                           id="interest_emergency" name="interest_emergency" 
                                           value="{{ old('interest_emergency', $settings->default_interest_rates['emergency'] ?? 5) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('interest_emergency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_personal" class="form-label">Personal</label>
                                    <input type="number" class="form-control @error('interest_personal') is-invalid @enderror" 
                                           id="interest_personal" name="interest_personal" 
                                           value="{{ old('interest_personal', $settings->default_interest_rates['personal'] ?? 10) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('interest_personal')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_education" class="form-label">Education</label>
                                    <input type="number" class="form-control @error('interest_education') is-invalid @enderror" 
                                           id="interest_education" name="interest_education" 
                                           value="{{ old('interest_education', $settings->default_interest_rates['education'] ?? 8) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('interest_education')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_housing" class="form-label">Housing</label>
                                    <input type="number" class="form-control @error('interest_housing') is-invalid @enderror" 
                                           id="interest_housing" name="interest_housing" 
                                           value="{{ old('interest_housing', $settings->default_interest_rates['housing'] ?? 12) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('interest_housing')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="interest_other" class="form-label">Other</label>
                                    <input type="number" class="form-control @error('interest_other') is-invalid @enderror" 
                                           id="interest_other" name="interest_other" 
                                           value="{{ old('interest_other', $settings->default_interest_rates['other'] ?? 10) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('interest_other')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Approval Settings -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-success mb-3">Approval Settings</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="auto_approve_below_amount" class="form-label">Auto-Approve Below (KES)</label>
                                    <input type="number" class="form-control @error('auto_approve_below_amount') is-invalid @enderror" 
                                           id="auto_approve_below_amount" name="auto_approve_below_amount" 
                                           value="{{ old('auto_approve_below_amount', $settings->auto_approve_below_amount) }}" 
                                           step="0.01" min="0" required>
                                    @error('auto_approve_below_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="require_guarantor_above_amount" class="form-label">Require Guarantor Above (KES)</label>
                                    <input type="number" class="form-control @error('require_guarantor_above_amount') is-invalid @enderror" 
                                           id="require_guarantor_above_amount" name="require_guarantor_above_amount" 
                                           value="{{ old('require_guarantor_above_amount', $settings->require_guarantor_above_amount) }}" 
                                           step="0.01" min="0" required>
                                    @error('require_guarantor_above_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="ceo_approval_threshold" class="form-label">CEO Approval Threshold (KES)</label>
                                    <input type="number" class="form-control @error('ceo_approval_threshold') is-invalid @enderror" 
                                           id="ceo_approval_threshold" name="ceo_approval_threshold" 
                                           value="{{ old('ceo_approval_threshold', $settings->ceo_approval_threshold) }}" 
                                           step="0.01" min="0" required>
                                    @error('ceo_approval_threshold')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="require_department_head_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_department_head_approval" 
                                           id="require_department_head_approval" value="1"
                                           {{ old('require_department_head_approval', $settings->require_department_head_approval) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="require_department_head_approval">
                                        Require Department Head Approval
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="require_finance_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_finance_approval" 
                                           id="require_finance_approval" value="1"
                                           {{ old('require_finance_approval', $settings->require_finance_approval) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="require_finance_approval">
                                        Require Finance Approval
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="require_ceo_approval_above_threshold" value="0">
                                    <input class="form-check-input" type="checkbox" name="require_ceo_approval_above_threshold" 
                                           id="require_ceo_approval_above_threshold" value="1"
                                           {{ old('require_ceo_approval_above_threshold', $settings->require_ceo_approval_above_threshold) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="require_ceo_approval_above_threshold">
                                        Require CEO Approval Above Threshold
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Loan Policies -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-warning mb-3">Loan Policies</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_multiple_loans" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_multiple_loans" 
                                           id="allow_multiple_loans" value="1"
                                           {{ old('allow_multiple_loans', $settings->allow_multiple_loans) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="allow_multiple_loans">
                                        Allow Multiple Loans
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_loan_with_pending_loan" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_loan_with_pending_loan" 
                                           id="allow_loan_with_pending_loan" value="1"
                                           {{ old('allow_loan_with_pending_loan', $settings->allow_loan_with_pending_loan) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="allow_loan_with_pending_loan">
                                        Allow Loan with Pending Loan
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_early_repayment" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_early_repayment" 
                                           id="allow_early_repayment" value="1"
                                           {{ old('allow_early_repayment', $settings->allow_early_repayment) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="allow_early_repayment">
                                        Allow Early Repayment
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="allow_payment_holidays" value="0">
                                    <input class="form-check-input" type="checkbox" name="allow_payment_holidays" 
                                           id="allow_payment_holidays" value="1"
                                           {{ old('allow_payment_holidays', $settings->allow_payment_holidays) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="allow_payment_holidays">
                                        Allow Payment Holidays
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Repayment & Notifications -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-info mb-3">Repayment & Notifications</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="max_payment_holidays" class="form-label">Maximum Payment Holidays</label>
                                    <input type="number" class="form-control @error('max_payment_holidays') is-invalid @enderror" 
                                           id="max_payment_holidays" name="max_payment_holidays" 
                                           value="{{ old('max_payment_holidays', $settings->max_payment_holidays) }}" 
                                           min="0" max="12" required>
                                    @error('max_payment_holidays')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="early_repayment_penalty_rate" class="form-label">Early Repayment Penalty (%)</label>
                                    <input type="number" class="form-control @error('early_repayment_penalty_rate') is-invalid @enderror" 
                                           id="early_repayment_penalty_rate" name="early_repayment_penalty_rate" 
                                           value="{{ old('early_repayment_penalty_rate', $settings->early_repayment_penalty_rate) }}" 
                                           step="0.01" min="0" max="100" required>
                                    @error('early_repayment_penalty_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="notification_days_before" class="form-label">Notification Days Before Deduction</label>
                                    <input type="number" class="form-control @error('notification_days_before') is-invalid @enderror" 
                                           id="notification_days_before" name="notification_days_before" 
                                           value="{{ old('notification_days_before', $settings->notification_days_before) }}" 
                                           min="1" max="30" required>
                                    @error('notification_days_before')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="notify_on_approval" value="0">
                                    <input class="form-check-input" type="checkbox" name="notify_on_approval" 
                                           id="notify_on_approval" value="1"
                                           {{ old('notify_on_approval', $settings->notify_on_approval) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="notify_on_approval">
                                        Notify Employee on Approval
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check mb-3">
                                    <input type="hidden" name="notify_before_deduction" value="0">
                                    <input class="form-check-input" type="checkbox" name="notify_before_deduction" 
                                           id="notify_before_deduction" value="1"
                                           {{ old('notify_before_deduction', $settings->notify_before_deduction) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="notify_before_deduction">
                                        Notify Before Deduction
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <!-- Terms & Conditions -->
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-secondary mb-3">Terms & Conditions</h5>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="terms_and_conditions" class="form-label">Terms & Conditions (Optional)</label>
                                    <textarea class="form-control @error('terms_and_conditions') is-invalid @enderror" 
                                              id="terms_and_conditions" name="terms_and_conditions" 
                                              rows="4">{{ old('terms_and_conditions', $settings->terms_and_conditions) }}</textarea>
                                    <small class="text-muted">These terms will be shown to employees when requesting loans</small>
                                    @error('terms_and_conditions')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Save Settings
                                </button>
                                <a href="{{ route('loan-settings.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
