<!-- Mobile Overlay -->
<div class="sidebar-overlay d-lg-none" id="sidebarOverlay"></div>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <!-- Mobile Close Button -->
    <div class="d-lg-none d-flex justify-content-end p-3">
        <button class="btn btn-link text-white" id="closeSidebar">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    
    <div class="logo">
        <i class="bi bi-building"></i> Qaya HRM
        @if(auth()->user() && !auth()->user()->is_system_admin && auth()->user()->organization)
            <div class="organization-context">
                <small class="text-yellow-500">{{ auth()->user()->organization->name }}</small>
            </div>
        @endif
    </div>
    
    <nav class="nav flex-column mt-3">
        <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>

        @can('view_employees')
        <a href="{{ route('employees.index') }}" class="nav-link {{ request()->routeIs('employees.*') ? 'active' : '' }}">
            <i class="bi bi-people"></i> Employees
        </a>
        @endcan

        @can('view_departments')
        <a href="{{ route('departments.index') }}" class="nav-link {{ request()->routeIs('departments.*') ? 'active' : '' }}">
            <i class="bi bi-diagram-3"></i> Departments
        </a>
        @endcan

        @can('view_attendance')
        <a href="{{ route('attendance.index') }}" class="nav-link {{ request()->routeIs('attendance.*') ? 'active' : '' }}">
            <i class="bi bi-calendar-check"></i> Attendance
        </a>
        @endcan

        @can('view_leaves')
        <a href="{{ route('leaves.index') }}" class="nav-link {{ request()->routeIs('leaves.*') ? 'active' : '' }}">
            <i class="bi bi-calendar-x"></i> Leaves
        </a>
        @endcan

        @can('view_announcements')
        <a href="{{ route('announcements.index') }}" class="nav-link {{ request()->routeIs('announcements.*') ? 'active' : '' }}">
            <i class="bi bi-megaphone"></i> Announcements
        </a>
        @endcan

        @can('view_payroll')
        <a href="{{ route('payroll.index') }}" class="nav-link {{ request()->routeIs('payroll.*') ? 'active' : '' }}">
            <i class="bi bi-cash-stack"></i> Payroll
        </a>
        @endcan

        @if(auth()->user()->employee)
        <a href="{{ route('loans.my-loans') }}" class="nav-link {{ request()->routeIs('loans.my-loans') || request()->routeIs('loans.request') ? 'active' : '' }}">
            <i class="bi bi-piggy-bank"></i> My Loans
        </a>
        @endif

        @can('manage_payroll')
        <a href="{{ route('loans.index') }}" class="nav-link {{ request()->routeIs('loans.index') || request()->routeIs('loans.show') || request()->routeIs('loans.create') || request()->routeIs('loans.edit') ? 'active' : '' }}">
            <i class="bi bi-bank"></i> Manage Loans
        </a>
        @endcan

        @can('view_job_postings')
        <a href="{{ route('job-postings.index') }}" class="nav-link {{ request()->routeIs('job-postings.*') ? 'active' : '' }}">
            <i class="bi bi-briefcase"></i> Recruitment
        </a>
        @endcan

        @can('view_payroll')
        <a href="{{ route('p9-forms.index') }}" class="nav-link {{ request()->routeIs('p9-forms.*') ? 'active' : '' }}">
            <i class="bi bi-file-earmark-text"></i> P9 Forms
        </a>
        @endcan

        @can('view_performance')
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle {{ request()->routeIs('performance.*') ? 'active' : '' }}" href="#" role="button" data-bs-toggle="dropdown">
                <i class="bi bi-graph-up"></i> Performance
            </a>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="{{ route('performance.index') }}">
                    <i class="bi bi-list"></i> Reviews
                </a></li>
                <li><a class="dropdown-item" href="{{ route('performance.goals.index') }}">
                    <i class="bi bi-bullseye"></i> Goals
                </a></li>
                <li><a class="dropdown-item" href="{{ route('performance.self-assessments.index') }}">
                    <i class="bi bi-person-check"></i> Self Assessments
                </a></li>
            </ul>
        </li>
        @endcan

        @if(auth()->user()->can('view_training') || auth()->user()->can('manage_training') || auth()->user()->can('manage_training_sessions'))
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle {{ request()->routeIs('training.*') ? 'active' : '' }}" href="#" role="button" data-bs-toggle="dropdown">
                <i class="bi bi-mortarboard"></i> Training
            </a>
            <ul class="dropdown-menu">
                @if(auth()->user()->can('view_training') || auth()->user()->can('manage_training'))
                <li><a class="dropdown-item" href="{{ route('training.index') }}">
                    <i class="bi bi-book"></i> Browse Programs
                </a></li>
                <li><a class="dropdown-item" href="{{ route('training.my-trainings') }}">
                    <i class="bi bi-person-workspace"></i> My Trainings
                </a></li>
                <li><a class="dropdown-item" href="{{ route('training.learning-paths.index') }}">
                    <i class="bi bi-map"></i> Learning Paths
                </a></li>
                <li><a class="dropdown-item" href="{{ route('training.learning-paths.my-paths') }}">
                    <i class="bi bi-person-lines-fill"></i> My Learning Paths
                </a></li>
                @endif
                
                @if(auth()->user()->can('view_training_recommendations') || auth()->user()->can('manage_training'))
                <li><a class="dropdown-item" href="{{ route('training.recommendations.index') }}">
                    <i class="bi bi-lightbulb"></i> Recommendations
                </a></li>
                @endif
                
                @if(auth()->user()->can('manage_training') || auth()->user()->can('view_training_reports'))
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="{{ route('training.dashboard') }}">
                        <i class="bi bi-speedometer2"></i> Training Dashboard
                    </a></li>
                    <li><a class="dropdown-item" href="{{ route('training.performance.index') }}">
                        <i class="bi bi-graph-up"></i> Performance Impact
                    </a></li>
                    <li><a class="dropdown-item" href="{{ route('training.performance.analytics') }}">
                        <i class="bi bi-bar-chart"></i> Training Analytics
                    </a></li>
                @endif
                
                @if(auth()->user()->can('view_training') || auth()->user()->can('manage_training') || auth()->user()->can('create_training_programs'))
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="{{ route('training.programs.index') }}">
                        <i class="bi bi-collection"></i> Manage Programs
                    </a></li>
                @endif
                
                @if(auth()->user()->can('manage_training_sessions') || auth()->user()->can('manage_training'))
                    <li><a class="dropdown-item" href="{{ route('training.sessions.index') }}">
                        <i class="bi bi-calendar-event"></i> Manage Sessions
                    </a></li>
                @endif
            </ul>
        </li>
        @endif

        @can('view_reports')
        <a href="{{ route('reports.index') }}" class="nav-link {{ request()->routeIs('reports.*') ? 'active' : '' }}">
            <i class="bi bi-file-earmark-text"></i> Reports
        </a>
        @endcan

        @if(auth()->user()->can('view_settings') || auth()->user()->canManageRoles())
        <a href="{{ route('settings.index') }}" class="nav-link {{ request()->routeIs('settings.*') && !request()->routeIs('settings.organization*') ? 'active' : '' }}">
            <i class="bi bi-gear"></i> Settings
        </a>
        @endif

        {{-- @role('org_admin')
        <a href="{{ route('settings.organization') }}" class="nav-link {{ request()->routeIs('settings.organization*') ? 'active' : '' }}">
            <i class="bi bi-building-gear"></i> Organization Settings
        </a>
        @endhasrole --}}

        {{-- @if(auth()->user()->canManageRoles())
        <a href="{{ route('roles.index') }}" class="nav-link {{ request()->routeIs('roles.*') ? 'active' : '' }}">
            <i class="bi bi-shield-lock"></i> Roles & Permissions
        </a>
        <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}">
            <i class="bi bi-person-gear"></i> User Management
        </a>
        @endif --}}

        @can('view_organization_audit_logs')
        <a href="{{ route('organization.audit-logs.index') }}" class="nav-link {{ request()->routeIs('organization.audit-logs.*') ? 'active' : '' }}">
            <i class="bi bi-clipboard-data"></i> Audit Logs
        </a>
        @endcan

        <!-- Subscription & Billing Section (org_admin only) -->
        @if(auth()->user() && !auth()->user()->is_system_admin && auth()->user()->organization && auth()->user()->hasRole('org_admin'))
            <div class="nav-section-divider"></div>
            <div class="nav-section-title">
                <small class="text-muted px-3">SUBSCRIPTION</small>
            </div>
            
            <a href="{{ route('subscription.show') }}" class="nav-link {{ request()->routeIs('subscription.*') ? 'active' : '' }}">
                <i class="bi bi-star"></i> My Subscription
            </a>
            
            <a href="{{ route('organization.payments.index') }}" class="nav-link {{ request()->routeIs('organization.payments.*') ? 'active' : '' }}">
                <i class="bi bi-credit-card"></i> Invoices & Payments
            </a>
        @endif
    </nav>
</div>

<style>
    /* Mobile Responsive Sidebar Styles */
    .sidebar-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1040;
        display: none;
    }

    .sidebar-overlay.show {
        display: block;
    }

    /* Mobile Sidebar Adjustments */
    @media (max-width: 991.98px) {
        .sidebar {
            transform: translateX(-100%);
            z-index: 1050;
            width: 280px;
        }

        .sidebar.show {
            transform: translateX(0);
        }

        .main-content {
            margin-left: 0;
        }

        .top-navbar {
            padding: 15px 20px;
        }

        .content-area {
            padding: 20px 15px;
        }
    }

    /* Tablet Adjustments */
    @media (min-width: 768px) and (max-width: 991.98px) {
        .content-area {
            padding: 25px 20px;
        }
    }

    /* Small Mobile Adjustments */
    @media (max-width: 575.98px) {
        .sidebar {
            width: 100%;
        }

        .top-navbar {
            padding: 10px 15px;
        }

        .top-navbar h4 {
            font-size: 1.1rem;
        }

        .content-area {
            padding: 15px 10px;
        }

        .stat-card {
            padding: 15px;
            margin-bottom: 15px;
        }

        .stat-card .stat-icon {
            width: 50px;
            height: 50px;
            font-size: 20px;
        }
    }

    /* Subscription Section Styles */
    .nav-section-divider {
        height: 1px;
        background: rgba(255, 255, 255, 0.1);
        margin: 15px 0;
    }

    .nav-section-title {
        margin: 10px 0 5px 0;
    }

    .nav-section-title small {
        font-size: 0.75rem;
        font-weight: 600;
        letter-spacing: 0.5px;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        const menuToggle = document.getElementById('menuToggle');
        const closeSidebar = document.getElementById('closeSidebar');

        // Toggle sidebar on mobile
        if (menuToggle) {
            menuToggle.addEventListener('click', function() {
                sidebar.classList.add('show');
                sidebarOverlay.classList.add('show');
                document.body.style.overflow = 'hidden';
            });
        }

        // Close sidebar
        function closeSidebarFunc() {
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            document.body.style.overflow = '';
        }

        if (closeSidebar) {
            closeSidebar.addEventListener('click', closeSidebarFunc);
        }

        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', closeSidebarFunc);
        }

        // Close sidebar when clicking on nav links on mobile
        const navLinks = sidebar.querySelectorAll('.nav-link');
        navLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth < 992) {
                    closeSidebarFunc();
                }
            });
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 992) {
                closeSidebarFunc();
            }
        });
    });
</script>