<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Qaya HRM')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Theme CSS: Use static file if available, fallback to inline -->
    @if(auth()->check() && auth()->user()->organization_id && file_exists(public_path('storage/themes/org_' . auth()->user()->organization_id . '.css')))
        <!-- Static Theme CSS (Cached) -->
        <link rel="stylesheet" href="{{ asset('storage/themes/org_' . auth()->user()->organization_id . '.css') }}?v={{ filemtime(public_path('storage/themes/org_' . auth()->user()->organization_id . '.css')) }}">
    @else
        <!-- Dynamic Theme Injection (Fallback) -->
        <style>
            :root {
                @if(isset($themeConfig['colors']))
                @foreach($themeConfig['colors'] as $key => $value)
                --color-{{ $key }}: {{ $value }};
                @endforeach
                @endif
                
                @if(isset($themeConfig['sidebar']))
                --sidebar-bg: {{ $themeConfig['sidebar']['background'] }};
                --sidebar-text: {{ $themeConfig['sidebar']['text'] }};
                --sidebar-hover: {{ $themeConfig['sidebar']['hover'] }};
                --sidebar-active: {{ $themeConfig['sidebar']['active'] }};
                @endif
                
                @if(isset($themeConfig['fonts']))
                @if($themeConfig['fonts']['primary'] ?? false)
                --font-primary: {{ $themeConfig['fonts']['primary'] }};
                @endif
                @if($themeConfig['fonts']['heading'] ?? false)
                --font-heading: {{ $themeConfig['fonts']['heading'] }};
                @endif
                @endif
            }
            
            @if(isset($themeConfig['fonts']['primary']) && $themeConfig['fonts']['primary'])
            body {
                font-family: {{ $themeConfig['fonts']['primary'] }}, sans-serif;
            }
            @endif
            
            @if(isset($themeConfig['fonts']['heading']) && $themeConfig['fonts']['heading'])
            h1, h2, h3, h4, h5, h6 {
                font-family: {{ $themeConfig['fonts']['heading'] }}, sans-serif;
            }
            @endif
        </style>
        
        @if(isset($themeConfig['custom_css']) && $themeConfig['custom_css'])
        <!-- Organization Custom CSS -->
        <style>
            {!! $themeConfig['custom_css'] !!}
        </style>
        @endif
    @endif
    
    @stack('styles')
</head>
<body>
    @include('layouts.sidebar')

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <div class="top-navbar">
            <div class="d-flex align-items-center">
                <!-- Mobile Menu Toggle -->
                <button class="btn btn-link d-lg-none me-3 p-0" id="menuToggle">
                    <i class="bi bi-list fs-4 text-dark"></i>
                </button>
                <!-- Hide page title on small screens to save space -->
                <h4 class="mb-0 d-none d-md-block">@yield('page-title', 'Dashboard')</h4>
                <!-- Show abbreviated title on mobile -->
                <h5 class="mb-0 d-md-none">@yield('mobile-title', 'Dashboard')</h5>
            </div>
            <div class="d-flex align-items-center">
                <!-- Hide welcome text on small screens -->
                <div class="me-3 d-none d-sm-block">
                    <span class="text-muted">
                        Welcome, <strong>{{ auth()->user()->name }}</strong>
                        @if(auth()->user()->roles->isNotEmpty())
                            <span class="badge bg-primary ms-1">{{ ucfirst(auth()->user()->roles->first()->name) }}</span>
                        @endif
                    </span>
                </div>
                <!-- Show only role badge on mobile -->
                <div class="me-2 d-sm-none">
                    @if(auth()->user()->roles->isNotEmpty())
                        <span class="badge bg-primary">{{ ucfirst(auth()->user()->roles->first()->name) }}</span>
                    @endif
                </div>
                <div class="dropdown">
                    <button class="btn btn-link text-dark dropdown-toggle" type="button" id="userDropdown" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle fs-4"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="{{ route('profile.show') }}"><i class="bi bi-person"></i> My Profile</a></li>
                        @if(auth()->user()->can('view_settings') || 
                            auth()->user()->can('edit_settings') || 
                            auth()->user()->can('view_organization_settings') || 
                            auth()->user()->can('manage_roles') || 
                            auth()->user()->can('view_users'))
                        <li><a class="dropdown-item" href="{{ route('settings.index') }}"><i class="bi bi-gear"></i> Settings</a></li>
                        @endif
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="dropdown-item">
                                    <i class="bi bi-box-arrow-right"></i> Logout
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="content-area">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @yield('content')
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    @stack('scripts')
</body>
</html>
