@extends('errors.layout')

@section('title', $title ?? 'Server Error')
@section('code', '500')

@section('content')
    <div class="error-icon text-danger">
        <i class="bi bi-exclamation-triangle"></i>
    </div>
    
    <p class="error-message">
        {{ $message ?? "Something went wrong on our end. Our technical team has been notified and is working to fix this issue as quickly as possible." }}
    </p>

    <div class="error-details">
        <h6><i class="bi bi-tools me-2"></i>What's happening?</h6>
        <p>This is a temporary server issue. The problem has been automatically logged and our development team will investigate it promptly.</p>
    </div>

    <div class="error-actions">
        <a href="javascript:location.reload()" class="btn-primary-custom">
            <i class="bi bi-arrow-clockwise"></i>
            Try Again
        </a>
        
        @auth
            <a href="{{ route('dashboard') }}" class="btn-secondary-custom">
                <i class="bi bi-house"></i>
                Go to Dashboard
            </a>
        @else
            <a href="{{ route('login') }}" class="btn-secondary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        @endauth
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-headset"></i>
            Contact Support
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-clock me-1"></i>
            <strong>Error Time:</strong> {{ now()->format('M d, Y \a\t g:i A') }}
            <br>
            <i class="bi bi-hash me-1"></i>
            <strong>Reference ID:</strong> {{ Str::random(8) }}
        </small>
    </div>
@endsection

@push('scripts')
<script>
    // Auto-refresh after 60 seconds
    setTimeout(function() {
        if (confirm('Would you like to try refreshing the page?')) {
            location.reload();
        }
    }, 60000);
</script>
@endpush