@extends('errors.layout')

@section('title', $title ?? 'Access Denied')
@section('code', '403')

@section('content')
    <div class="error-icon text-danger">
        <i class="bi bi-shield-x"></i>
    </div>
    
    <p class="error-message">
        {{ $message ?? "You don't have the necessary permissions to access this resource. This area is restricted to authorized personnel only." }}
    </p>

    <div class="error-details">
        <h6><i class="bi bi-exclamation-triangle me-2"></i>Why am I seeing this?</h6>
        <p>Your current role doesn't include the permissions needed for this action. If you believe this is an error, please contact your administrator or HR department.</p>
    </div>

    <div class="error-actions">
        @auth
            <a href="{{ route('dashboard') }}" class="btn-primary-custom">
                <i class="bi bi-house"></i>
                Return to Dashboard
            </a>
            
            <a href="javascript:history.back()" class="btn-secondary-custom">
                <i class="bi bi-arrow-left"></i>
                Go Back
            </a>
            
            @if(auth()->user()->canManageRoles() || auth()->user()->hasRole(['org_admin', 'hr_manager']))
                <a href="{{ route('roles.index') }}" class="btn-success-custom">
                    <i class="bi bi-shield-check"></i>
                    Manage Permissions
                </a>
            @else
                <a href="mailto:admin@qayahrms.com" class="btn-success-custom">
                    <i class="bi bi-person-gear"></i>
                    Request Access
                </a>
            @endif
        @else
            <a href="{{ route('login') }}" class="btn-primary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        @endauth
    </div>

    @auth
    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-person-badge me-1"></i>
            <strong>Your Role:</strong> 
            @if(auth()->user()->roles->isNotEmpty())
                {{ ucfirst(auth()->user()->roles->first()->name) }}
            @else
                No role assigned
            @endif
        </small>
    </div>
    @endauth
@endsection