@extends('layouts.app')

@section('title', 'Employees')
@section('page-title', 'Employees')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees']
    ]" />

    <x-page-header title="Employees" description="Manage employee records">
        <x-slot:actions>
            @can('create_employees')
            <div class="btn-group me-2" role="group">
                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="bi bi-upload"></i> Import
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="{{ route('employees.import.view') }}">
                        <i class="bi bi-upload"></i> Import from Excel/CSV
                    </a></li>
                    <li><a class="dropdown-item" href="{{ route('employees.template') }}">
                        <i class="bi bi-download"></i> Download Template
                    </a></li>
                </ul>
            </div>
            @endcan

            @can('view_employees')
            <div class="btn-group me-2" role="group">
                <button type="button" class="btn btn-outline-success dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="bi bi-download"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="{{ route('employees.export', array_merge(request()->all(), ['format' => 'xlsx'])) }}">
                        <i class="bi bi-file-excel"></i> Export to Excel
                    </a></li>
                    <li><a class="dropdown-item" href="{{ route('employees.export', array_merge(request()->all(), ['format' => 'csv'])) }}">
                        <i class="bi bi-filetype-csv"></i> Export to CSV
                    </a></li>
                </ul>
            </div>
            @endcan

            @can('create_employees')
            <a href="{{ route('employees.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Add Employee
            </a>
            @endcan
        </x-slot:actions>
    </x-page-header>

    <x-alert type="success" :message="session('success')" />

    <!-- Filters -->
    <x-filter-form :action="route('employees.index')">
        <div class="col-md-3">
            <input type="text" name="search" class="form-control" placeholder="Search by name, code, email..." value="{{ request('search') }}">
        </div>
        <div class="col-md-2">
            <select name="department" class="form-select">
                <option value="">All Departments</option>
                @foreach($departments as $dept)
                    <option value="{{ $dept->id }}" {{ request('department') == $dept->id ? 'selected' : '' }}>
                        {{ $dept->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2">
            <select name="status" class="form-select">
                <option value="">All Status</option>
                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                <option value="on_leave" {{ request('status') == 'on_leave' ? 'selected' : '' }}>On Leave</option>
                <option value="terminated" {{ request('status') == 'terminated' ? 'selected' : '' }}>Terminated</option>
            </select>
        </div>
        <div class="col-md-3">
            <select name="group_by" class="form-select">
                <option value="">No Grouping</option>
                <option value="department" {{ request('group_by') == 'department' ? 'selected' : '' }}>Group by Department</option>
                <option value="status" {{ request('group_by') == 'status' ? 'selected' : '' }}>Group by Status</option>
                <option value="position" {{ request('group_by') == 'position' ? 'selected' : '' }}>Group by Position</option>
            </select>
        </div>
    </x-filter-form>

    <!-- Employees Table -->
    <div class="table-card">
        @if($groupedEmployees)
            @foreach($groupedEmployees as $groupName => $groupItems)
                <div class="mb-4">
                    <h5 class="bg-light p-3 rounded">
                        <i class="bi bi-folder"></i> {{ $groupName ?: 'Ungrouped' }}
                        <span class="badge bg-primary">{{ $groupItems->count() }}</span>
                    </h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="d-none d-md-table-cell">Code</th>
                                    <th>Name</th>
                                    <th class="d-none d-sm-table-cell">Email</th>
                                    @if(request('group_by') != 'department')
                                    <th class="d-none d-lg-table-cell">Department</th>
                                    @endif
                                    @if(request('group_by') != 'position')
                                    <th class="d-none d-lg-table-cell">Position</th>
                                    @endif
                                    <th class="d-none d-md-table-cell">Payroll Ready</th>
                                    @if(request('group_by') != 'status')
                                    <th class="d-none d-sm-table-cell">Status</th>
                                    @endif
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($groupItems as $employee)
                                    <tr>
                                        <td class="d-none d-md-table-cell">{{ $employee->employee_code }}</td>
                                        <td>
                                            @can('view_employee_details')
                                            <a href="{{ route('employees.show', $employee) }}">
                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                            </a>
                                            @else
                                            {{ $employee->first_name }} {{ $employee->last_name }}
                                            @endcan
                                            <!-- Show additional info on mobile -->
                                            <div class="d-md-none">
                                                <small class="text-muted d-block">{{ $employee->employee_code }}</small>
                                                <small class="text-muted d-block d-sm-none">{{ $employee->email }}</small>
                                            </div>
                                        </td>
                                        <td class="d-none d-sm-table-cell">{{ $employee->email }}</td>
                                        @if(request('group_by') != 'department')
                                        <td class="d-none d-lg-table-cell">{{ $employee->department->name ?? 'N/A' }}</td>
                                        @endif
                                        @if(request('group_by') != 'position')
                                        <td class="d-none d-lg-table-cell">{{ $employee->position->name ?? 'N/A' }}</td>
                                        @endif
                                        <td class="d-none d-md-table-cell">
                                            @if($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0)
                                                <span class="badge bg-success" title="Ready for payroll generation">
                                                    <i class="bi bi-check-circle"></i> Ready
                                                </span>
                                            @else
                                                <span class="badge bg-warning text-dark" title="Missing KRA PIN, NHIF, NSSF, or Basic Salary">
                                                    <i class="bi bi-exclamation-triangle"></i> Incomplete
                                                </span>
                                            @endif
                                        </td>
                                        @if(request('group_by') != 'status')
                                        <td class="d-none d-sm-table-cell">
                                            @if($employee->status == 'active')
                                                <span class="badge bg-success">Active</span>
                                            @elseif($employee->status == 'inactive')
                                                <span class="badge bg-secondary">Inactive</span>
                                            @elseif($employee->status == 'on_leave')
                                                <span class="badge bg-warning">On Leave</span>
                                            @else
                                                <span class="badge bg-danger">Terminated</span>
                                            @endif
                                        </td>
                                        @endif
                                        <td>
                                            @can('view_employee_details')
                                            <a href="{{ route('employees.show', $employee) }}" class="btn btn-sm btn-info">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            @endcan
                                            @can('edit_employees')
                                                @unless(auth()->user()->hasRole('org_admin'))
                                                <a href="{{ route('employees.edit', $employee) }}" class="btn btn-sm btn-warning d-none d-sm-inline-block">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                @endunless
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endforeach
        @else
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Department</th>
                        <th>Position</th>
                        <th>Payroll Ready</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employees as $employee)
                        <tr>
                            <td>{{ $employee->employee_code }}</td>
                            <td>
                                @can('view_employee_details')
                                <a href="{{ route('employees.show', $employee) }}">
                                    {{ $employee->first_name }} {{ $employee->last_name }}
                                </a>
                                @else
                                {{ $employee->first_name }} {{ $employee->last_name }}
                                @endcan
                            </td>
                            <td>{{ $employee->email }}</td>
                            <td>{{ $employee->department->name ?? 'N/A' }}</td>
                            <td>{{ $employee->position->name ?? 'N/A' }}</td>
                            <td>
                                @if($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0)
                                    <span class="badge bg-success" title="Ready for payroll generation">
                                        <i class="bi bi-check-circle"></i> Ready
                                    </span>
                                @else
                                    <span class="badge bg-warning text-dark" title="Missing KRA PIN, NHIF, NSSF, or Basic Salary">
                                        <i class="bi bi-exclamation-triangle"></i> Incomplete
                                    </span>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-status-{{ $employee->status }}">
                                    {{ ucfirst(str_replace('_', ' ', $employee->status)) }}
                                </span>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    @can('view_employee_details')
                                    <a href="{{ route('employees.show', $employee) }}" class="btn btn-info" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @endcan
                                    @can('edit_employees')
                                        @unless(auth()->user()->hasRole('org_admin'))
                                        <a href="{{ route('employees.edit', $employee) }}" class="btn btn-warning" title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @endunless
                                    @endcan
                                    @can('delete_employees')
                                        @unless(auth()->user()->hasRole('org_admin'))
                                        <form action="{{ route('employees.destroy', $employee) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" title="Delete" onclick="return confirm('Are you sure?')">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                        @endunless
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center">No employees found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($employees)
        <div class="mt-3">
            {{ $employees->links() }}
        </div>
        @endif
        @endif
    </div>
@endsection
