@extends('layouts.app')

@section('title', 'Upload Document')
@section('page-title', 'Upload Document')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees', 'url' => auth()->user()->can('view_employees') ? route('employees.index') : null],
        ['label' => $employee->first_name . ' ' . $employee->last_name, 'url' => auth()->user()->can('view_employees') ? route('employees.show', $employee) : null],
        ['label' => 'Documents', 'url' => auth()->user()->can('view_employees') ? route('employees.documents.index', $employee) : null],
        ['label' => 'Upload']
    ]" />

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-upload"></i> Upload Document for {{ $employee->first_name }} {{ $employee->last_name }}</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('employees.documents.store', $employee) }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <x-form.input name="title" label="Document Title" required />

                        <x-form.select 
                            name="type" 
                            label="Document Type" 
                            required
                            :options="[
                                'contract' => 'Employment Contract',
                                'certificate' => 'Certificate',
                                'id_document' => 'ID Document',
                                'other' => 'Other'
                            ]" />

                        <x-form.textarea name="description" label="Description" rows="3" />

                        <x-form.file 
                            name="file" 
                            label="File" 
                            required
                            help="Max file size: 10MB. Supported formats: PDF, DOC, DOCX, JPG, PNG" />

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input type="date" name="issue_date" label="Issue Date" />
                            </div>

                            <div class="col-md-6">
                                <x-form.input type="date" name="expiry_date" label="Expiry Date" />
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-upload"></i> Upload Document
                            </button>
                            <a href="{{ route('employees.documents.index', $employee) }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
