@component('mail::message')
# Verify Your Email Address

Hello {{ $user->name }},

Welcome to {{ config('app.name') }}! Please verify your email address by clicking the button below.

@component('mail::button', ['url' => $url])
Verify Email Address
@endcomponent

This verification link will expire in 24 hours.

If you did not create an account, no further action is required.

**Account Details:**
- Email: {{ $user->email }}
- Registration Date: {{ $user->created_at->format('M d, Y H:i') }}
- IP Address: {{ request()->ip() }}

Thanks,<br>
{{ config('app.name') }} Team

---

If you're having trouble clicking the "Verify Email Address" button, copy and paste the URL below into your web browser:
{{ $url }}
@endcomponent