@extends('layouts.app')

@section('title', 'Edit Department')
@section('page-title', 'Edit Department')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Departments', 'url' => auth()->user()->can('view_departments') ? route('departments.index') : null],
        ['label' => $department->name, 'url' => auth()->user()->can('view_departments') ? route('departments.show', $department) : null],
        ['label' => 'Edit']
    ]" />

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="table-card">
                <form action="{{ route('departments.update', $department) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <x-form.input name="name" label="Department Name" required :value="$department->name" />

                    <x-form.textarea 
                        name="description" 
                        label="Description"
                        rows="3"
                        :value="$department->description" />

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.select 
                                name="parent_id" 
                                label="Parent Department"
                                :value="$department->parent_id"
                                :options="$departments->filter(fn($d) => $d->id != $department->id)->pluck('name', 'id')->toArray()"
                                help="Select parent department for hierarchy" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="manager_id" 
                                label="Department Manager"
                                :value="$department->manager_id"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' (' . $e->employee_code . ')'])->toArray()" />
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.color 
                                name="color" 
                                label="Department Color"
                                :value="$department->color ?? '#714b67'"
                                help="Color for visual identification" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="active" 
                                label="Status"
                                :value="(string)$department->active"
                                :options="['1' => 'Active', '0' => 'Inactive']" />
                        </div>
                    </div>

                    <x-form.button-group 
                        cancelUrl="{{ route('departments.show', $department) }}"
                        submitText="Update Department"
                        submitIcon="bi-check-circle" />
                </form>
            </div>
        </div>
    </div>
@endsection
