@props(['type' => null, 'daysRemaining' => null, 'endsAt' => null, 'upgradeUrl' => null])

@if($type === 'trial')
    <!-- Trial Banner -->
    <div class="alert alert-info alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-clock-history fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Trial Period Active</h5>
                <p class="mb-0">
                    You have <strong>{{ $daysRemaining }} days</strong> remaining in your trial. 
                    Enjoying your plan? 
                    <a href="{{ $upgradeUrl }}" class="alert-link">Upgrade now</a> to continue after trial ends.
                </p>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@elseif($type === 'expired')
    <!-- Expired Banner -->
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-exclamation-triangle fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Trial Expired</h5>
                <p class="mb-0">
                    Your trial period has ended. 
                    <a href="{{ $upgradeUrl }}" class="alert-link fw-bold">Subscribe now</a> to continue using all features.
                </p>
            </div>
        </div>
    </div>
@elseif($type === 'past_due')
    <!-- Past Due Banner -->
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-exclamation-circle fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Payment Overdue</h5>
                <p class="mb-0">
                    Your subscription payment is overdue. 
                    <a href="{{ route('organization.payments.index') }}" class="alert-link fw-bold">Pay now</a> to avoid service interruption.
                </p>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@elseif($type === 'cancelled')
    <!-- Cancelled Banner -->
    <div class="alert alert-secondary alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-info-circle fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Subscription Cancelled</h5>
                <p class="mb-0">
                    Your subscription will remain active until {{ $endsAt?->format('M d, Y') }}. 
                    <a href="{{ route('subscription.show') }}" class="alert-link">Reactivate subscription</a>
                </p>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

