@props([
    'status',
    'type' => 'auto',
    'size' => 'md',
])

@php
    // Auto-detect badge type based on status value
    if ($type === 'auto') {
        $statusLower = strtolower($status);
        
        $typeMap = [
            // Common status mappings
            'active' => 'success',
            'inactive' => 'secondary',
            'pending' => 'warning',
            'approved' => 'success',
            'rejected' => 'danger',
            'cancelled' => 'secondary',
            'completed' => 'success',
            'draft' => 'warning',
            'published' => 'success',
            'archived' => 'secondary',
            'paid' => 'success',
            'unpaid' => 'danger',
            'processing' => 'info',
            'processed' => 'info',
            'failed' => 'danger',
            'success' => 'success',
            'error' => 'danger',
            'warning' => 'warning',
            'info' => 'info',
            // Priority mappings
            'urgent' => 'danger',
            'high' => 'warning',
            'medium' => 'info',
            'low' => 'secondary',
        ];
        
        $type = $typeMap[$statusLower] ?? 'primary';
    }
    
    $sizeClass = $size === 'sm' ? 'badge-sm' : ($size === 'lg' ? 'fs-6' : '');
@endphp

<span class="badge bg-{{ $type }} {{ $sizeClass }}" {{ $attributes }}>
    {{ ucfirst($status) }}
</span>
