@props([
    'stats' => [],
    'columns' => 4,
])

@php
    $colClass = match($columns) {
        2 => 'col-md-6',
        3 => 'col-md-4',
        4 => 'col-md-3',
        6 => 'col-md-2',
        default => 'col-md-3',
    };
@endphp

<div class="row mb-4">
    @foreach($stats as $stat)
        <div class="{{ $colClass }} mb-3">
            <div class="stat-card bg-{{ $stat['type'] ?? 'primary' }}">
                <div class="stat-icon">
                    <i class="bi bi-{{ $stat['icon'] }}"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value text-white">{{ $stat['value'] }}</div>
                    <div class="stat-label text-white">{{ $stat['label'] }}</div>
                    @if(isset($stat['subtitle']))
                        <small class="text-white-50">{{ $stat['subtitle'] }}</small>
                    @endif
                </div>
            </div>
        </div>
    @endforeach
</div>
