@props([
    'title',
    'value',
    'icon' => null,
    'type' => 'primary', // primary, success, warning, danger, info, secondary
    'color' => null, // Alias for type
    'subtitle' => null,
    'trend' => null, // 'up', 'down', or null
])

@php
    // Support both 'type' and 'color' props
    $cardType = $color ?? $type;
@endphp

<div class="stat-card stat-card-{{ $cardType }}" {{ $attributes }}>
    <div class="d-flex align-items-center">
        @if($icon)
        <div class="stat-icon stat-icon-{{ $cardType }}">
            <i class="bi bi-{{ $icon }}"></i>
        </div>
        @endif
        <div class="ms-3 flex-grow-1">
            <h3 class="stat-value mb-0">{{ $value }}</h3>
            <p class="stat-title text-muted mb-0">{{ $title }}</p>
            @if($subtitle)
                <small class="stat-subtitle text-{{ $cardType }}">
                    @if($trend === 'up')
                        <i class="bi bi-arrow-up"></i>
                    @elseif($trend === 'down')
                        <i class="bi bi-arrow-down"></i>
                    @endif
                    {{ $subtitle }}
                </small>
            @endif
        </div>
    </div>
</div>
