@props([
    'icon',
    'title' => null,
    'message' => null, // Alias for title
    'description' => null,
])

@php
    $displayTitle = $title ?? $message;
@endphp

<div class="text-center py-5">
    <i class="bi bi-{{ $icon }}" style="font-size: 48px; color: #ccc;"></i>
    
    @if($displayTitle)
    <h5 class="text-muted mt-3 mb-2">{{ $displayTitle }}</h5>
    @endif
    
    @if($description)
        <p class="text-muted mb-3">{{ $description }}</p>
    @endif
    
    @isset($actions)
        <div class="mt-3">
            {{ $actions }}
        </div>
    @endisset
</div>
