@props([
    'type' => 'success',
    'message' => null,
    'dismissible' => true,
    'icon' => null,
])

@php
    $icons = [
        'success' => 'check-circle',
        'danger' => 'exclamation-triangle',
        'warning' => 'exclamation-circle',
        'info' => 'info-circle',
    ];
    
    $displayIcon = $icon ?? ($icons[$type] ?? 'info-circle');
@endphp

@if($message || $slot->isNotEmpty())
<div class="alert alert-{{ $type }} {{ $dismissible ? 'alert-dismissible' : '' }} fade show" role="alert">
    <i class="bi bi-{{ $displayIcon }} me-2"></i>
    {{ $message ?? $slot }}
    
    @if($dismissible)
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    @endif
</div>
@endif
