<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdraw Application - {{ $application->jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                
                <!-- Back Button -->
                <div class="mb-4">
                    <a href="{{ route('candidate.track', $application->tracking_token) }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Dashboard
                    </a>
                </div>

                <!-- Withdraw Form -->
                <div class="card shadow-sm">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Withdraw Application</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <i class="bi bi-info-circle"></i> <strong>Are you sure?</strong> This action cannot be undone.
                        </div>

                        <p class="mb-3">You are about to withdraw your application for:</p>
                        <div class="bg-light p-3 rounded mb-4">
                            <h6 class="mb-1">{{ $application->jobPosting->title }}</h6>
                            <p class="text-muted small mb-0">{{ $application->jobPosting->organization->name }}</p>
                        </div>

                        <form method="POST" action="{{ route('candidate.withdraw.confirm', $application->tracking_token) }}">
                            @csrf
                            
                            <div class="mb-3">
                                <label for="reason" class="form-label">Reason for Withdrawal (Optional)</label>
                                <textarea class="form-control" id="reason" name="reason" rows="3" 
                                          placeholder="Help us improve by sharing why you're withdrawing..."></textarea>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-danger btn-lg">
                                    <i class="bi bi-x-circle"></i> Confirm Withdrawal
                                </button>
                                <a href="{{ route('candidate.track', $application->tracking_token) }}" class="btn btn-outline-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
